# Contributing to CMB2 Conditionals

Thank you for your interest in contributing back to CMB2 Conditionals. Please help us review your issues and/or merge your pull requests by following the below guidelines.

#### NOTE: The issues section is for bug reports and feature requests only.
Support is not offered for this library, and the likelihood that the maintainers will respond is very low.

Before reporting a bug
---
1. Search [issues](https://github.com/jcchavezs/cmb2-conditionals/issues) to see if the issue has been previously reported.
2. Install the master version of CMB2 Conditionals and test there.


How to report a bug
---
1. Specify the version number for both WordPress and CMB2 Conditionals.
3. Describe the problem in detail. Explain what happened, and what you expected would happen.
4. Provide a small test-case and a link to a [gist](https://gist.github.com/) containing your entire metabox registration code.
5. If helpful, include a screenshot. Annotate the screenshot for clarity.


How to contribute to CMB2 Conditionals
---
All contributions welcome. If you would like to submit a pull request, please follow the steps below.

1. Make sure you have a GitHub account.
2. Fork the repository on GitHub.
3. **Check out the master version of CMB2 Conditionals.**
4. **Verify your issue still exists in the master branch.**
5. Make changes to your clone of the repository.
	1. Please follow the [WordPress code standards](https://make.wordpress.org/core/handbook/coding-standards).
	2. Use self descriptive names for the functions, so you can avoid inline documentation.
	3. Separate the changes in atomic commits doing just one thing per commit.
	4. When committing, reference your issue (by adding [#XX] at the begining of the message) and include a note about the fix.
	5. **Keep PRs as small as possible** and follow [well known best practices when submiting a PR](http://blog.ploeh.dk/2015/01/15/10-tips-for-better-pull-requests/). **Open one PR per each issue. Do not open one PR for more than one issue.**
6. [Submit a pull request](https://help.github.com/articles/creating-a-pull-request/).

**Note:** You may gain more ground and avoid unecessary effort if you first open an issue with the proposed changes, but this step is not necessary.

Additional Resources
---

* [General GitHub Documentation](http://help.github.com/)
* [GitHub Pull Request documentation](http://help.github.com/send-pull-requests/)
