<?php
$tour_program_style = get_post_meta( get_the_ID(), 'tours_program_style', true );
if ( empty( $tour_program_style ) ) {
	$tour_program_style = 'style1';
}
if ( $tour_program_style == 'style1' || $tour_program_style == 'style3' ) {
	$tour_programs = get_post_meta( get_the_ID(), 'tours_program', true );
} else {
	$tour_programs = get_post_meta( get_the_ID(), 'tours_program_bgr', true );
}
if ( ! empty( $tour_programs ) ) {
	?>
	<div class="accordion-item">
		<h2 class="st-heading-section" id="headingItinerary">
			<button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseItinerary" aria-expanded="true" aria-controls="collapseItinerary">
				<?php echo __( 'Itinerary', 'traveler' ); ?>
			</button>
		</h2>
		<div id="collapseItinerary" class="accordion-collapse collapse show" aria-labelledby="headingItinerary" data-bs-parent="#headingItinerary">
			<div class="accordion-body">
				<div class="st-program-list <?php echo esc_attr( $tour_program_style ); ?>">
					<?php
					$tour_program_style = get_post_meta( get_the_ID(), 'tours_program_style', true );
					if ( empty( $tour_program_style ) ) {
						$tour_program_style = 'style1';
					}
					if ( $tour_program_style == 'style4' ) {
						echo stt_elementorv2()->loadView( 'services/tour/single/item/itenirary/' . esc_attr( $tour_program_style ) );
					} else {
						echo st()->load_template( 'layouts/elementor/tour/single/item/itenirary/' . esc_attr( $tour_program_style ) );
					}
					?>
				</div>
			</div>
		</div>
	</div>
<?php } ?>
