<?php
$room_id = TravelHelper::post_translated(get_the_ID());
$url = get_the_permalink();
?>
<div class="room-item">
    <div class="thumbnail">
        <a href="<?php echo esc_url($url) ?>">
            <img src="<?php echo get_the_post_thumbnail_url(null, [800,600]) ?>" alt="<?php echo TravelHelper::get_alt_image();?>" class="img-fluid img-full st-hover-grow">
        </a>
    </div>
    <div class="content">
        <h3 class="name">
            <a href="<?php echo esc_url($url) ?>" class="">
                <?php echo esc_html(get_the_title($room_id)); ?>
            </a>
        </h3>
        <div class="facilities">

            <?php if ( $room_footage = get_post_meta( $room_id, 'room_footage', true ) ): ?>
                <p class="item">
                    <span class="stt-icon stt-icon-area"></span>
                    <span class="text"><?php echo sprintf(esc_html__('S: %s', 'traveler'), $room_footage); ?><?php echo __('m<sup>2</sup>', 'traveler');?></span>
                </p>
            <?php endif; ?>

            <?php if ( $bed = get_post_meta( $room_id, 'bed_number', true ) ): ?>
                <p class="item">
                    <span class="stt-icon stt-icon-bed"></span>
                    <span class="text"><?php echo sprintf(esc_html__('Beds: %s', 'traveler'), $bed) ?></span>
                </p>
            <?php endif; ?>

            <?php if ( $adult = (int)get_post_meta( $room_id, 'adult_number', true ) ): ?>
                <p class="item">
                    <span class="stt-icon stt-icon-adult"></span>
                    <span class="text"><?php echo sprintf(esc_html__('Adults: %s', 'traveler'), $adult) ?></span>
                </p>
            <?php endif; ?>

            <?php if ( $child = (int)get_post_meta( $room_id, 'children_number', true ) ): ?>
                <p class="item">
                    <span class="stt-icon stt-icon-baby"></span>
                    <span class="text"><?php echo sprintf(esc_html__('Child: %s', 'traveler'), $child) ?></span>
                </p>
            <?php endif; ?>

        </div>

        <?php

        echo '<div class="price-wrapper">';

        ?>



		<?php
        if ($price_by_per_person == 'on') :
            echo __('From:', 'traveler');
            echo sprintf('<span class="price">%s</span>', TravelHelper::format_money($sale_price));
            echo '<span class="unit">';
            echo sprintf(_n('/person', '/%d persons', $total_person, 'traveler'), $total_person);
            echo sprintf(_n('/night', '/%d nights', $numberday, 'traveler'), $numberday);
            echo '</span>';
        else:
            echo __('from ', 'traveler');
            echo sprintf('<span class="price">%s</span>', TravelHelper::format_money($sale_price));
            echo '<span class="unit">';
            echo sprintf(_n('/night', '/ %d nights', $numberday, 'traveler'), $numberday);
            echo '</span>';
        endif;

		echo '</div>';
		?>



        <a href="<?php echo esc_url($url); ?>" class="btn-show-price">
            <?php echo esc_html__( 'Room Detail', 'traveler' ) ?>
        </a>

    </div>
</div>