<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 */
global $class;
$thim_options = get_theme_mods();
$column = isset( $thim_options['archive_post_column'] ) ? get_theme_mod( 'archive_post_column' ) : 1;
if (has_post_format('aside')) {
    $class = 'aside-item image-item';
} elseif (has_post_format('chat')) {
    $class = 'chat-item image-item';
} elseif (has_post_format('gallery')) {
    $class = 'slide-item';
} elseif (has_post_format('image')) {
    $class = 'image-item';
} elseif (has_post_format('link')) {
    $class = 'link-item image-item';
} elseif (has_post_format('quote')) {
    $class = 'quote-item image-item';
}elseif (has_post_format('video')) {
    $class = 'video-item';
} elseif (has_post_format('audio')) {
    $class = 'audio-item';
}
else {
    $class = 'image-item';
}

// check haspost thumbnail
if(has_post_thumbnail()){
    $thumbnail = '';
}
else {
    $thumbnail = 'have-no-thumbnail';
}

$class  = 'item-blog'.' '. $class .' '. $thumbnail;

$class .= ' no-have-date';

if ( isset( $_GET['column'] ) ) {
	$class = 'item-blog'.' '. $class .' '. $thumbnail;
}
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $class ); ?>>
    <?php
    if ( has_post_format( 'video' ) ) {
        $video_key = get_post_meta( get_the_ID(), 'thim_video', true );
        $html_video = '';
        if( $video_key ) {
            if (strlen(strstr($video_key, 'iframe')) > 0) {
                $html_video = $video_key;
            } else {
                $html_video = '<iframe width="100%" height="400" src="'.esc_url( $video_key ).'"></iframe>';
            }
        } else {
            if( has_post_thumbnail() ) $html_video = get_the_post_thumbnail(get_the_ID(), 'full');
        }
        echo '<div class="entry-top media-item"><div class="pic">';
        echo ent2ncr($html_video);
        echo '</div></div>';
    } else {
        if ( class_exists( 'TP' ) ) {
            echo '<div class="entry-top media-item"><div class="pic">';
            do_action( 'thim_entry_top', 'full' );
            echo '</div></div>';
        } else {
            if ( has_post_thumbnail() ) {
                ?>
                <div class="entry-top media-item">
                    <div class="pic">
                        <div class="post-thumbnail">
                            <?php the_post_thumbnail(); ?>
                        </div><!-- .post-thumbnail -->
                    </div>
                    <?php thim_entry_meta_date(); ?>
                </div>
                <?php
            }
        }
    }
    ?>

    <div class="entry-content text-item">
        <?php
        if ( has_post_format( 'link' ) && thim_meta( 'thim_link_url' ) && thim_meta( 'thim_link_text' ) ) {
            $url  = thim_meta( 'thim_link_url' );
            $text = thim_meta( 'thim_link_text' );
            if ( $url && $text ) { ?>
                <header class="entry-header">
                    <h4 class="entry-title title">
                        <a class="link" href="<?php echo esc_url( $url ); ?>"><?php echo esc_html( $text ); ?></a>
                    </h4>
                </header><!-- .entry-header -->
                <?php
            }
            ?>
            <div class="entry-summary content">
                <?php the_excerpt(); ?>
            </div><!-- .entry-summary -->
            <div class="readmore">
                <a href="<?php echo esc_url( get_permalink() ); ?>" class="btn-learnmore btn-small shape-round"><?php echo esc_html__( 'Read More', 'vividly' ); ?></a>
            </div><!-- .read-more -->

        <?php } elseif ( has_post_format( 'quote' ) && thim_meta( 'thim_quote_author_url' ) ) {

            $author     = thim_meta( 'thim_quote_author_text' );
            $author_url = thim_meta( 'thim_quote_author_url' );
            if ( $author_url ) {
                $author = ' <a href=' . esc_url( $author_url ) . '>' . $author . '</a>';
            }
            ?>
            <header class="entry-header">
                <?php the_title( sprintf( '<h4 class="entry-title title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' ); ?>
            </header><!-- .entry-header -->
            <div class="entry-summary content">
                <?php if ( $author ) { ?>
                    <div class="box-header box-quote">
                        <?php the_excerpt(); ?>
                    </div>
                <?php } ?>
            </div><!-- .entry-summary -->
            <div class="readmore">
                <a href="<?php echo esc_url( get_permalink() ); ?>" class="btn-learnmore btn-small shape-round"><?php echo esc_html__( 'Read More', 'vividly' ); ?></a>
            </div><!-- .read-more -->
            <?php
        } elseif ( has_post_format( 'audio' ) ) { ?>
            <header class="entry-header">
                <div class="entry-meta">
                    <?php the_title( sprintf( '<h4 class="entry-title title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' ); ?>
                    <?php thim_entry_meta(); ?>
                </div>
            </header><!-- .entry-header -->
            <div class="entry-summary content">
                <?php
                the_excerpt();
                ?>
            </div><!-- .entry-summary -->
            <div class="readmore">
                <a href="<?php echo esc_url( get_permalink() ); ?>" class="btn-learnmore btn-small shape-round"><?php echo esc_html__( 'Read More', 'vividly' ); ?></a>
            </div><!-- .read-more -->

        <?php } elseif ( has_post_format( 'chat' ) ) { ?>
            <header class="entry-header">
                <div class="entry-meta">
                    <?php the_title( sprintf( '<h4 class="entry-title title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' ); ?>
                    <?php thim_entry_meta(); ?>
                </div>
            </header><!-- .entry-header -->
            <div class="entry-summary content">
                <?php the_excerpt(); ?>
            </div><!-- .entry-summary -->
            <div class="readmore">
                <a href="<?php echo esc_url( get_permalink() ); ?>" class="btn-learnmore btn-small shape-round"><?php echo esc_html__( 'Read More', 'vividly' ); ?></a>
            </div><!-- .read-more -->

        <?php } else { ?>
            <header class="entry-header">
                <?php the_title( sprintf( '<h4 class="entry-title title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' ); ?>
            </header>
            <!-- .entry-header -->

            <?php thim_entry_meta(); ?>

            <div class="entry-summary content">
                <?php
                the_excerpt();
                ?>
            </div><!-- .entry-summary -->
            <div class="readmore">
                <a href="<?php echo esc_url( get_permalink() ); ?>" class="btn-learnmore btn-small shape-round"><?php echo esc_html__( 'Read More', 'vividly' ); ?></a>
            </div>
        <?php }
        ?>
    </div><!-- .entry-content -->

</article><!-- #post-## -->
