<?php
/**
 * Template part for displaying single.
 *
 * @link    https://codex.wordpress.org/Template_Hierarchy
 *
 */

$class = ' bl-blog-detail';
$class .= ' no-have-date';
$class .= has_post_thumbnail() ? '' : ' have-no-thumbnail';

?>

<article id="post-<?php the_ID(); ?>" <?php post_class($class); ?>>
	<div class="content-inner">
        <div class="head-blog">
            <h2 class="title-blog-detail">
                <?php the_title();?>
            </h2>
            <div class="info-blog-detail">
                <?php thim_entry_meta(); ?>
            </div>
        </div>
        <div class="media-blog-detail">
            <div class="pic">
                <?php if ( get_theme_mod( 'blog_single_feature_image', true ) ) :
                    do_action( 'thim_entry_top', 'full' );
                endif; ?>
            </div>
            <?php thim_entry_meta_date(); ?>

        </div><!-- .entry-top -->
		<div class="entry-content text-blog-detail<?php echo !get_theme_mod( 'show_sharing', false ) ? ' no-share' : '';?>">
            <?php if ( get_theme_mod( 'show_sharing', false ) ) :?>
                <div class="wrap-share-blog sticky-sidebar">
                    <div class="theiaStickySidebar">
                        <div class="share">
                            <?php do_action( 'thim_social_share' ); ?>
                        </div>
                    </div>
                </div>
            <?php endif;?>
			<div class="entry-description content-blog">
				<?php
				if ( has_post_format( 'chat' ) ) {
					thim_get_list_group_chat();
				}
				?>

                <?php if( get_the_content() ) {?>
                    <div class="content"><?php the_content();?></div>
                <?php }?>

                <?php
                wp_link_pages(
                    array(
                        'before' => '<div class="page-links"><label>' . esc_html__( 'Pages:', 'vividly' ) . '</label>',
                        'after'  => '</div>',
                        'link_before'      => '<span>',
                        'link_after'       => '</span>',
                    )
                );
                ?>

                <div class="entry-tag-share">
                    <?php if ( get_theme_mod( 'show_tags_meta_tags', true ) ) : ?>
                        <?php thim_entry_meta_tags(); ?>
                    <?php endif; ?>
                </div>

                <?php do_action( 'thim_about_author' ); ?>

                <div class="navigate-blog">
                    <?php do_action('thim_navigate_next_blog');?>
                    <?php do_action('thim_navigate_preview_blog');?>
                </div>

                <?php
                // If comments are open or we have at least one comment, load up the comment template
                if ( comments_open() || '0' != get_comments_number() ) :
                    comments_template();
                endif;
                ?>

			</div>

		</div><!-- .entry-content -->

	</div><!-- .content-inner -->
</article><!-- #post-## -->