<?php
/**
 * Template part for displaying single.
 *
 * @link    https://codex.wordpress.org/Template_Hierarchy
 *
 */

?>
<?php
if( taxonomy_exists('type') ) {
    $type = wp_get_post_terms(get_the_ID(),'type');
}
if( taxonomy_exists('rating') ) {
    $rate = wp_get_post_terms(get_the_ID(),'rating');
}
if( taxonomy_exists('genre') ) {
    $genre = wp_get_post_terms(get_the_ID(),'genre');
}
if( taxonomy_exists('country') ) {
    $country = wp_get_post_terms(get_the_ID(),'country');
}
?>
<article id="post-<?php the_ID(); ?>" <?php post_class("bl-video-detail"); ?>>
    <div class="player-video">
        <?php if( get_post_meta(get_the_ID(),'thim_video_meta_player_sc',true) ) {?>
            <div class="bg-video">
                <?php
                $sc = get_post_meta(get_the_ID(),'thim_video_meta_player_sc',true);
                echo do_shortcode($sc);
                ?>
            </div>
        <?php } elseif ( get_post_meta(get_the_ID(),'thim_video_meta_player_iframe',true) ) {?>
            <div class="bg-video">
                <?php
                echo get_post_meta(get_the_ID(),'thim_video_meta_player_iframe',true)
                ?>
            </div>
        <?php } elseif ( get_post_meta(get_the_ID(),'thim_video',true) ) {?>
            <?php
            $video_key = get_post_meta( get_the_ID(), 'thim_video', true );
            if (strlen(strstr($video_key, 'iframe')) > 0) {
                $html_video = $video_key;
            } else {
                $html_video = '<iframe width="100%" height="600" src="'.esc_url( $video_key ).'"></iframe>';
            }
            ?>
            <div class="bg-video">
                <?php
                echo ent2ncr($html_video);
                ?>
            </div>
        <?php }?>
    </div>
    <div class="detail-video">
        <div class="info-detail sticky-sidebar">
            <div class="inner-info">
                <div class="media-video">
                    <?php if(has_post_thumbnail()) {?>
                        <div class="pic-video">
                            <?php echo thim_feature_image(400,450)?>
                        </div>
                    <?php }?>

                    <div class="meta-info">
                        <?php if( get_post_meta(get_the_ID(),'thim_video_meta_imdb',true) ) {?>
                            <div class="imdb">
                                <span class="value"><?php echo get_post_meta(get_the_ID(),'thim_video_meta_imdb',true);?></span><?php echo esc_html__( 'IMDb', 'vividly' );?>
                            </div>
                        <?php }?>
                        <?php if( !empty($type) ) {?>
                            <div class="labels">
                                <?php foreach ($type as $item) {
                                    $color = get_term_meta( $item->term_id, 'thim_type_color', true );
                                    ?>
                                    <div class="label"<?php echo ent2ncr($color) ? ' style="background-color: '.$color.';"' : ''; ?>>
                                        <?php echo esc_html($item->name);?>
                                    </div>
                                <?php }?>
                            </div>
                        <?php }?>
                    </div>

                    <div class="more-info">

                        <?php if( !empty($rate) ) {?>
                            <span class="item-info">
                            <?php echo esc_html__( 'Rating:', 'vividly' );?>
                                <i class="ion ion-android-star"></i>
                                <?php echo esc_html($rate[0]->name);?>/10
                        </span>
                        <?php }?>
                        <?php if( get_post_meta(get_the_ID(),'thim_video_meta_views',true) ) {?>
                            <span class="item-info">
                        <i class="ion ion-eye"></i>
                                <?php echo esc_html(get_post_meta(get_the_ID(),'thim_video_meta_views',true));?>
                                <?php echo esc_html__( 'Views', 'vividly' );?>
                    </span>
                        <?php }?>
                    </div>
                </div>

                <div class="info-video">
                    <?php if( get_post_meta(get_the_ID(),'thim_video_meta_actors',true) ) {?>
                        <div class="item-info">
                        <span class="name-item">
                            <?php echo esc_html__( 'Actors:', 'vividly' );?>
                        </span>
                            <span class="value-item">
                            <?php echo get_post_meta(get_the_ID(),'thim_video_meta_actors',true);?>
                        </span>
                        </div>
                    <?php }?>
                    <?php if( get_post_meta(get_the_ID(),'thim_video_meta_writer',true) ) {?>
                        <div class="item-info">
                        <span class="name-item">
                            <?php echo esc_html__( 'Writer:', 'vividly' );?>
                        </span>
                            <span class="value-item">
                            <?php echo get_post_meta(get_the_ID(),'thim_video_meta_writer',true);?>
                        </span>
                        </div>
                    <?php }?>
                    <?php if( get_post_meta(get_the_ID(),'thim_video_meta_release_date',true) ) {?>
                        <div class="item-info">
                        <span class="name-item">
                            <?php echo esc_html__( 'Release Date:', 'vividly' );?>
                        </span>
                            <span class="value-item">
                            <?php echo get_post_meta(get_the_ID(),'thim_video_meta_release_date',true);?>
                        </span>
                        </div>
                    <?php }?>
                    <?php if( !empty($genre) ) {?>
                        <div class="item-info">
                        <span class="name-item">
                            <?php echo esc_html__( 'Genres:', 'vividly' );?>
                        </span>
                            <span class="value-item">
                            <?php echo esc_html($genre[0]->name);?>
                        </span>
                        </div>
                    <?php }?>
                    <?php if( !empty($country) ) {?>
                        <div class="item-info">
                        <span class="name-item">
                            <?php echo esc_html__( 'Country:', 'vividly' );?>
                        </span>
                            <span class="value-item">
                            <?php echo esc_html($country[0]->name);?>
                        </span>
                        </div>
                    <?php }?>
                    <?php if( get_post_meta(get_the_ID(),'thim_video_meta_runtime',true) ) {?>
                        <div class="item-info">
                        <span class="name-item">
                            <?php echo esc_html__( 'Runtime:', 'vividly' );?>
                        </span>
                            <span class="value-item">
                            <?php echo get_post_meta(get_the_ID(),'thim_video_meta_runtime',true);?>
                        </span>
                        </div>
                    <?php }?>
                    <?php if( get_post_meta(get_the_ID(),'thim_video_meta_language',true) ) {?>
                        <div class="item-info">
                        <span class="name-item">
                            <?php echo esc_html__( 'Language:', 'vividly' );?>
                        </span>
                            <span class="value-item">
                            <?php echo get_post_meta(get_the_ID(),'thim_video_meta_language',true);?>
                        </span>
                        </div>
                    <?php }?>

                </div>

            </div>
        </div>
        <div class="content-detail">

            <div class="field-detail">
                <div class="content-field">
                    <?php
                    // Get post content
                    the_content();
                    ?>
                </div>

            </div>

            <?php
            wp_link_pages(
                array(
                    'before' => '<div class="page-links"><label>' . esc_html__( 'Pages:', 'vividly' ) . '</label>',
                    'after'  => '</div>',
                    'link_before'      => '<span>',
                    'link_after'       => '</span>',
                )
            );
            ?>

            <div class="entry-tag-share">
                <?php if ( get_theme_mod( 'show_tags_meta_tags', true ) ) : ?>
                    <?php thim_entry_meta_tags(); ?>
                <?php endif; ?>
            </div>

            <?php do_action( 'thim_about_author' ); ?>

            <div class="navigate-blog">
                <?php do_action('thim_navigate_next_blog');?>
                <?php do_action('thim_navigate_preview_blog');?>
            </div>

            <?php
            // If comments are open or we have at least one comment, load up the comment template
            if ( comments_open() || '0' != get_comments_number() ) :
                comments_template();
            endif;
            ?>

            <?php get_template_part( 'templates/template-parts/related-single' ); ?>

        </div>
    </div>

</article><!-- #post-## -->