<?php
/**
 * Template part for displaying results in search pages.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 */

// check haspost thumbnail
$thumbnail = 'have-no-thumbnail';

$class = '';
$class  = 'item-blog'.' '. $class .' '. $thumbnail;

$class .= ' no-have-date';

if ( isset( $_GET['column'] ) ) {
    $class = 'item-blog'.' '. $class .' '. $thumbnail;
}
?>

<article id="post-<?php the_ID(); ?>" <?php post_class($class); ?>>
    <div class="entry-top media-item">

        <?php thim_entry_meta_date(); ?>


    </div><!-- .entry-top -->

    <div class="entry-content text-item">
        <?php
        if ( has_post_format( 'link' ) && thim_meta( 'thim_link_url' ) && thim_meta( 'thim_link_text' ) ) {
            $url  = thim_meta( 'thim_link_url' );
            $text = thim_meta( 'thim_link_text' );
            if ( $url && $text ) { ?>
                <header class="entry-header">
                    <h4 class="entry-title title">
                        <a class="link" href="<?php echo esc_url( $url ); ?>"><?php echo esc_html( $text ); ?></a>
                    </h4>
                </header><!-- .entry-header -->
                <?php
            }
            ?>
            <div class="entry-summary content">
                <?php the_excerpt(); ?>
            </div><!-- .entry-summary -->
            <div class="readmore">
                <a href="<?php echo esc_url( get_permalink() ); ?>" class="btn-learnmore btn-small shape-round"><?php echo esc_html__( 'Read More', 'vividly' ); ?></a>
            </div><!-- .read-more -->

        <?php } elseif ( has_post_format( 'quote' ) && thim_meta( 'thim_quote_author_url' ) ) {

            $author     = thim_meta( 'thim_quote_author_text' );
            $author_url = thim_meta( 'thim_quote_author_url' );
            if ( $author_url ) {
                $author = ' <a href=' . esc_url( $author_url ) . '>' . $author . '</a>';
            }
            ?>
            <header class="entry-header">
                <?php the_title( sprintf( '<h4 class="entry-title title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' ); ?>
            </header><!-- .entry-header -->
            <div class="entry-summary content">
                <?php if ( $author ) { ?>
                    <div class="box-header box-quote">
                        <?php the_excerpt(); ?>
                    </div>
                <?php } ?>
            </div><!-- .entry-summary -->
            <div class="readmore">
                <a href="<?php echo esc_url( get_permalink() ); ?>" class="btn-learnmore btn-small shape-round"><?php echo esc_html__( 'Read More', 'vividly' ); ?></a>
            </div><!-- .read-more -->
            <?php
        } elseif ( has_post_format( 'audio' ) ) { ?>
            <header class="entry-header">
                <div class="entry-meta">
                    <?php the_title( sprintf( '<h4 class="entry-title title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' ); ?>
                    <?php thim_entry_meta(); ?>
                </div>
            </header><!-- .entry-header -->
            <div class="entry-summary content">
                <?php
                the_excerpt();
                ?>
            </div><!-- .entry-summary -->
            <div class="readmore">
                <a href="<?php echo esc_url( get_permalink() ); ?>" class="btn-learnmore btn-small shape-round"><?php echo esc_html__( 'Read More', 'vividly' ); ?></a>
            </div><!-- .read-more -->

        <?php } elseif ( has_post_format( 'chat' ) ) { ?>
            <header class="entry-header">
                <div class="entry-meta">
                    <?php the_title( sprintf( '<h4 class="entry-title title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' ); ?>
                    <?php thim_entry_meta(); ?>
                </div>
            </header><!-- .entry-header -->
            <div class="entry-summary content">
                <?php the_excerpt(); ?>
            </div><!-- .entry-summary -->
            <div class="readmore">
                <a href="<?php echo esc_url( get_permalink() ); ?>" class="btn-learnmore btn-small shape-round"><?php echo esc_html__( 'Read More', 'vividly' ); ?></a>
            </div><!-- .read-more -->

        <?php } else { ?>
            <header class="entry-header">
                <?php the_title( sprintf( '<h4 class="entry-title title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' ); ?>
            </header>
            <!-- .entry-header -->

            <?php thim_entry_meta(); ?>

            <div class="entry-summary content">
                <?php
                the_excerpt();
                ?>
            </div><!-- .entry-summary -->
            <div class="readmore">
                <a href="<?php echo esc_url( get_permalink() ); ?>" class="btn-learnmore btn-small shape-round"><?php echo esc_html__( 'Read More', 'vividly' ); ?></a>
            </div>
        <?php }
        ?>
    </div><!-- .entry-content -->
</article><!-- #post-## -->
