<?php
/**
 * Header Mobile Menu Template
 *
 * @package Thim_Starter_Theme
 */
?>

<div class="menu-mobile-effect navbar-toggle" data-effect="mobile-effect">
	<span class="icon-bar"></span>
	<span class="icon-bar"></span>
	<span class="icon-bar"></span>
</div>

<div class="inner-menu">
    <div class="widget-area">
        <div class="widget nav navbar-nav">
            <h3 class="widget-title"><?php echo esc_html__('Menu', 'vividly')?></h3>
            <ul class="menu">
                <?php
                if ( has_nav_menu( 'primary' ) ) {
                    wp_nav_menu( array(
                        'theme_location' => 'primary',
                        'container'      => false,
                        'items_wrap'     => '%3$s'
                    ) );
                } else {
                    wp_nav_menu( array(
                        'theme_location' => '',
                        'container'      => false,
                        'items_wrap'     => '%3$s'
                    ) );
                }
                ?>
            </ul>
        </div>

        <?php if( is_active_sidebar( 'canvas' ) ) :?>
        <div class="canvas-area">
            <?php dynamic_sidebar( 'canvas' ); ?>
        </div>
        <?php endif;?>
    </div>
</div>