<?php
/**
 * Custom template tags for this theme.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 */

/**
 * author meta
 *
 * @return void
 */
function thim_entry_meta_author() {
	echo thim_get_entry_meta_author();
}

/**
 * Get author meta
 *
 * @return string
 */
function thim_get_entry_meta_author() {
	$html = '<span class="author info-item"> <i class="ion ion-android-person"></i> ';
	$html .= esc_html__( 'by ', 'vividly' ) . sprintf( '<a href="%1$s" rel="author">%2$s</a>', esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ), esc_html( get_the_author() ) ) . '';
	$html .= '</span>';

	return $html;
}

/**
 * date meta
 *
 * @return void
 */
function thim_entry_meta_date() {
	echo thim_get_entry_meta_date();
}


/**
 * Get date meta
 *
 * @return string
 */
function thim_get_entry_meta_date() {
	$html = '<div class="entry-date date"><span class="number">' . get_the_date('d') . '</span>' . get_the_date( 'M, Y' ) . '</div>';

	return $html;
}


/**
 * Get category meta
 *
 * @return void
 */
function thim_entry_meta_category() {
	echo thim_get_entry_meta_category();
}

/**
 * Get category meta
 *
 * @return string
 */
function thim_get_entry_meta_category( $limit = '-1' ) {
    $categories = get_the_category();
    $html = '';
    if ( ! empty( $categories ) ) {
        $html       .= '<span class="meta-category info-item"><i class="ion-ios-pricetags-outline" aria-hidden="true"></i> ';
        if ( $limit == '-1' ) {
            $i = 0;
            foreach ( $categories as $cat ) {
                $i++;
                $html .= '<a href="' . esc_url( get_category_link( $cat->term_id ) ) . '">' . esc_html( $cat->name ) . '</a>';
                if($i<count($categories)) $html .= '<span>,</span> ';
            }
        } else {
            foreach ( $categories as $key => $cat ) {
                if ( $key == $limit ) {
                    break;
                }
                $html .= '<a href="' . esc_url( get_category_link( $cat->term_id ) ) . '"> <i class="ion-ios-pricetags-outline" aria-hidden="true"></i> ' . esc_html( $cat->name ) . '</a> ';
            }
        }
        $html .= '</span>';
    }

    return $html;
}

/**
 * Get tags meta
 *
 * @return void
 */
function thim_entry_meta_tags() {
	echo thim_get_entry_meta_tags();
}


/**
 * Get tags meta
 *
 * @return string
 */
function thim_get_entry_meta_tags() {
	$tags_list = get_the_tag_list( '', esc_html__( '', 'vividly' ) );
	if ( $tags_list ) {
	    $label = (count(get_the_terms(get_the_ID(), 'post_tag'))>1) ? esc_html__( 'Tags:', 'vividly' ) : esc_html__( 'Tag:', 'vividly' );
		return sprintf( '<div class="tags-links info-item tags"><span class="name-field">' . $label . '</span>' . esc_html__('%1$s', 'vividly').'</div>', $tags_list );
	}

	return '';
}

/**
 * comment number
 *
 * @return void
 */
function thim_entry_meta_comment_number() {
	if (  comments_open() || get_comments_number()  ) {
		?>
		<span class="comment-total info-item"><i class="ion ion-android-chat"></i>
			<?php comments_popup_link( '0 Comments', '1 Comment', '% Comments', 'comments-link', 'Comments are off for this post' ); ?>
		</span>
		<?php
	}
}

/**
 * Prints HTML with meta information for the current post-date/time and author.
 *
 * @return string HTML for meta tags
 */
if ( ! function_exists( 'thim_entry_meta' ) ) :
	function thim_entry_meta() {
		echo '<div class="entry-meta info">';

		if ( get_theme_mod( 'show_author_meta_tags', true ) ) :
			echo thim_get_entry_meta_author();
		endif;

		$date = get_the_title() ? get_the_date() : '<a href="'.get_the_permalink().'">'.get_the_date().'</a>';
        echo '<span class="date info-item"><i class="ion-ios-alarm"></i> ' . $date . '</span>';


		if ( get_theme_mod( 'show_category_meta_tags', true ) ) :
			echo thim_get_entry_meta_category();
		endif;

		if ( get_theme_mod( 'show_comment_meta_tags', true ) ) :
			thim_entry_meta_comment_number();
		endif;

		echo '</div>';
	}
endif;

/**
 * Get pagination
 *
 * @return string
 */

if ( ! function_exists( 'thim_paging_nav' ) ) :

	/**
	 * Display navigation to next/previous set of posts when applicable.
	 */
	function thim_paging_nav() {
		global $wp_rewrite;
		if ( $GLOBALS['wp_query']->max_num_pages < 2 ) {
			return;
		}
		$paged        = get_query_var( 'paged' ) ? intval( get_query_var( 'paged' ) ) : 1;
		$pagenum_link = html_entity_decode( get_pagenum_link() );
		$query_args   = array();
		$url_parts    = explode( '?', $pagenum_link );

		if ( isset( $url_parts[1] ) ) {
			wp_parse_str( $url_parts[1], $query_args );
		}

		$pagenum_link = esc_url( remove_query_arg( array_keys( $query_args ), $pagenum_link ) );
		$pagenum_link = trailingslashit( $pagenum_link ) . '%_%';

		$format = $wp_rewrite->using_index_permalinks() && ! strpos( $pagenum_link, 'index.php' ) ? 'index.php/' : '';
		$format .= $wp_rewrite->using_permalinks() ? user_trailingslashit( 'page/%#%', 'paged' ) : '?paged=%#%';
		// Set up paginated links.
		$links = paginate_links( array(
			'base'      => $pagenum_link,
			'format'    => $format,
			'total'     => $GLOBALS['wp_query']->max_num_pages,
			'current'   => $paged,
			'mid_size'  => 2,
			'add_args'  => array_map( 'urlencode', $query_args ),
			'prev_text' => '<i class="ion ion-ios-arrow-thin-left"></i> Prev',
			'next_text' => 'Next <i class="ion ion-ios-arrow-thin-right"></i>',
			'type'      => 'array'
		) );

		if ( $links ) : ?>
			<ul class="loop-pagination">
				<?php foreach ( $links as $link ) {
					echo '<li>' . $link . '</li>';
				} ?>
			</ul><!-- .pagination -->
		<?php endif;
	}
endif;
/**
 * get pagination blog 2
 *
 * @return bool
 */
function thim_paging_nav_blog_isotope() {
    ?>
    <div class="pagi-blog">
        <?php
                previous_posts_link( '<i class="ion ion-ios-arrow-thin-left"></i> OLDER POSTS' ); ?>



            <?php
                next_posts_link('NEWER POSTS <i class="ion ion-ios-arrow-thin-right"></i>');
            ?>

    </div>
    <?php
}

add_filter('next_posts_link_attributes', 'posts_link_attributes_2');
add_filter('previous_posts_link_attributes', 'posts_link_attributes_1');

function posts_link_attributes_1() {
    return 'class="item-pagi prev"';
}
function posts_link_attributes_2() {
    return 'class="item-pagi next"';
}

/**
 * Returns true if a blog has more than 1 category.
 *
 * @return bool
 */
function thim_categorized_blog() {
	if ( false === ( $all_the_cool_cats = get_transient( 'thim_categories' ) ) ) {
		// Create an array of all the categories that are attached to posts.
		$all_the_cool_cats = get_categories( array(
			'fields'     => 'ids',
			'hide_empty' => 1,
			// We only need to know if there is more than one category.
			'number'     => 2,
		) );

		// Count the number of categories that are attached to the posts.
		$all_the_cool_cats = count( $all_the_cool_cats );

		set_transient( 'thim_categories', $all_the_cool_cats );
	}

	if ( $all_the_cool_cats > 1 ) {
		// This blog has more than 1 category so thim_categorized_blog should return true.
		return true;
	} else {
		// This blog has only 1 category so thim_categorized_blog should return false.
		return false;
	}
}

/**
 * Flush out the transients used in thim_categorized_blog.
 *
 * @return bool
 */
if ( ! function_exists( 'thim_category_transient_flusher' ) ) {
	function thim_category_transient_flusher() {
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}
		// Like, beat it. Dig?
		delete_transient( 'thim_categories' );
	}
}
add_action( 'edit_category', 'thim_category_transient_flusher' );
add_action( 'save_post', 'thim_category_transient_flusher' );

/**
 * Change default comment fields
 *
 * @param $fields
 *
 * @return string
 */
if ( ! function_exists( 'thim_new_comment_fields' ) ) {
	function thim_new_comment_fields( $fields ) {
		$commenter = wp_get_current_commenter();
		$req       = get_option( 'require_name_email' );
		$aria_req  = ( $req ? 'aria-required=true' : '' );

		$fields = array(
			'author' => '<p class="comment-form-author">' . '<input placeholder="' . esc_attr__( 'Name', 'vividly' ) . ( $req ? ' *' : '' ) . '" id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30" ' . $aria_req . ' /></p>',
			'email'  => '<p class="comment-form-email">' . '<input placeholder="' . esc_attr__( 'Email', 'vividly' ) . ( $req ? ' *' : '' ) . '" id="email" name="email" type="text" value="' . esc_attr( $commenter['comment_author_email'] ) . '" size="30" ' . $aria_req . ' /></p>',
			'url'    => '<p class="comment-form-url">' . '<input placeholder="' . esc_attr__( 'Website', 'vividly' ) . '" id="url" name="url" type="text" value="' . esc_attr( $commenter['comment_author_url'] ) . '" size="30" /></p>',
		);

		return $fields;
	}
}
add_filter( 'comment_form_default_fields', 'thim_new_comment_fields' );

/**
 * Show list comments
 *
 * @return string
 */
if ( ! function_exists( 'thim_comment' ) ) {
	function thim_comment( $comment, $args, $depth ) {
		$GLOBALS['comment'] = $comment;
		//extract( $args, EXTR_SKIP );
		if ( 'div' == $args['style'] ) {
			$tag       = 'div';
			$add_below = 'comment';
		} else {
			$tag       = 'li';
			$add_below = 'div-comment';
		}
		?>
		<<?php echo ent2ncr( $tag );
		echo ' '; ?><?php comment_class( 'description_comment' ) ?> id="comment-<?php comment_ID() ?>">
		<?php
		if ( $args['avatar_size'] != 0 ) {
			echo get_avatar( $comment, 70 );
		} ?>
		<div class="content-comment">
			<div class="author">
				<?php printf( '<span class="author-name">%s</span>', get_comment_author_link() ) ?>
			</div>
			<?php if ( $comment->comment_approved == '0' ) : ?>
				<em class="comment-awaiting-moderation"><?php esc_html_e( 'Your comment is awaiting moderation.', 'vividly' ) ?></em>
			<?php endif; ?>
			<div class="message">
				<?php comment_text() ?>
			</div>
            <div class="meta">
                <span class="comment-extra-info">
					<?php
                    printf( get_comment_date() );
                    echo esc_html__( ' at ', 'vividly' );
                    printf( get_comment_time() ) ?>
				</span>
                <span class="link-comment">
                    <?php comment_reply_link( array_merge( $args, array(
                        'add_below' => $add_below,
                        'depth'     => $depth,
                        'max_depth' => $args['max_depth']
                    ) ) ) ?>
                    <?php edit_comment_link( esc_html__( 'Edit', 'vividly' ), '', '' ); ?>
                </span>
            </div>
		</div>
		<div class="clear"></div>
		<?php
	}
}

/**
 *
 * Excerpt Length
 * @return string
 */
function thim_excerpt_length() {
	$thim_options = get_theme_mods();

	if ( isset( $thim_options['excerpt_archive_content'] ) ) {
		$length = get_theme_mod( 'excerpt_archive_content' );
	} else {
		$length = '50';
	}

	return $length;
}

add_filter( 'excerpt_length', 'thim_excerpt_length', 99999 );

/**
 * Change excerpt more
 * @return string
 */
function thim_excerpt_more() {
	return '...';
}

add_filter( 'excerpt_more', 'thim_excerpt_more' );

/**
 * Get related posts
 *
 * @return WP_Query
 */
function thim_get_related_posts() {
	global $post;
	$number_posts  = (int) get_theme_mod( 'blog_single_related_post_number', 3 );
	$tags          = wp_get_post_tags( $post->ID );
	$related_query = new WP_Query();

	if ( isset( $tags[0] ) ) {
		$first_tag = $tags[0]->term_id;

		$related_args  = array(
			'tag__in'             => array( $first_tag ),
			'post__not_in'        => array( $post->ID ),
			'posts_per_page'      => $number_posts,
			'ignore_sticky_posts' => 1
		);
		$related_query = new WP_Query( $related_args );
	}

	return $related_query;
}

/**
 * Get related columns class
 *
 * @param string $class
 *
 * @return string
 */
function thim_get_related_columns_class( $class = '' ) {
	return $class . ' col-md-' . ( 12 / get_theme_mod( 'blog_single_related_post_column', 3 ) );
}

/**
 * Get group chat content for post format chat
 *
 * @todo Should move function thim_meta to theme.
 *
 * @return string
 */
function thim_get_list_group_chat() {
	$group_chat = thim_meta( 'thim_group_chat' );
	if($group_chat) {
        foreach ( $group_chat as $key => $value ) {
            echo '<ul class="group-chat"><li>';
            echo '<span class="chat-name">' . esc_attr( $value['thim_chat_name'] ) . ':</span><span class="chat-message">' . esc_attr( $value['thim_chat_content'] ) . '</span>';
            echo '</li></ul>';
        }
    }
}

/**
 * Get archive title
 *
 * Display the archive title based on the queried object.
 *
 * @return string
 */
if ( ! function_exists( 'thim_archive_title' ) ) :
	function thim_archive_title( $before = '', $after = '' ) {
		if ( is_category() ) {
			$title = sprintf( esc_html__( '%s', 'vividly' ), single_cat_title( '', false ) );
		} elseif ( is_tag() ) {
			$title = sprintf( esc_html__( '%s', 'vividly' ), single_tag_title( '', false ) );
		} elseif ( is_author() ) {
			$title = sprintf( esc_html__( '%s', 'vividly' ), '<span class="vcard">' . get_the_author() . '</span>' );
		} elseif ( is_year() ) {
			$title = sprintf( esc_html__( 'Year: %s', 'vividly' ), get_the_date( 'Y' ) );
		} elseif ( is_month() ) {
			$title = sprintf( esc_html__( 'Month: %s', 'vividly' ), get_the_date( 'F Y' ) );
		} elseif ( is_day() ) {
			$title = sprintf( esc_html__( 'Day: %s', 'vividly' ), get_the_date( 'F j, Y' ) );
		} elseif ( is_tax( 'post_format', 'post-format-aside' ) ) {
			$title = esc_html__( 'Asides', 'vividly' );
		} elseif ( is_tax( 'post_format', 'post-format-gallery' ) ) {
			$title = esc_html__( 'Galleries', 'vividly' );
		} elseif ( is_tax( 'post_format', 'post-format-image' ) ) {
			$title = esc_html__( 'Images', 'vividly' );
		} elseif ( is_tax( 'post_format', 'post-format-video' ) ) {
			$title = esc_html__( 'Videos', 'vividly' );
		} elseif ( is_tax( 'post_format', 'post-format-quote' ) ) {
			$title = esc_html__( 'Quotes', 'vividly' );
		} elseif ( is_tax( 'post_format', 'post-format-link' ) ) {
			$title = esc_html__( 'Links', 'vividly' );
		} elseif ( is_tax( 'post_format', 'post-format-status' ) ) {
			$title = esc_html__( 'Statuses', 'vividly' );
		} elseif ( is_tax( 'post_format', 'post-format-audio' ) ) {
			$title = esc_html__( 'Audio', 'vividly' );
		} elseif ( is_tax( 'post_format', 'post-format-chat' ) ) {
			$title = esc_html__( 'Chats', 'vividly' );
		} elseif ( is_post_type_archive() ) {
			$title = sprintf( esc_html__( '%s', 'vividly' ), post_type_archive_title( '', false ) );
		} elseif ( is_tax() ) {
			$tax = get_taxonomy( get_queried_object()->taxonomy );
			/* translators: 1: Taxonomy singular name, 2: Current taxonomy term */
			$title = sprintf( esc_html__( '%1$s: %2$s', 'vividly' ), $tax->labels->singular_name, single_term_title( '', false ) );
		} elseif ( is_404() ) {
			$title = esc_html__( '404 Page', 'vividly' );
		} elseif ( is_search() ) {
			$title = esc_html__( 'Search Results Page', 'vividly' );
		} else {
			$title = esc_html__( 'Archives', 'vividly' );
		}
		/**
		 * Filter the archive title.
		 *
		 * @param string $title Archive title to be displayed.
		 */
		if ( ! empty( $title ) ) {
			echo ent2ncr( $before . $title . $after );
		}
	}
endif;
/**
 * Get author social link
 *
 * @return string
 */
function thim_get_author_social_link() {
	$user = new WP_User( get_the_author_meta( 'ID' ) );

	$link_facebook  = get_the_author_meta( 'facebook' );
	$link_twitter   = get_the_author_meta( 'twitter' );
	$link_skype     = get_the_author_meta( 'skype' );
	$link_pinterest = get_the_author_meta( 'pinterest' );
	?>

	<div class="socials-author">
		<?php if ( ! empty( $link_facebook ) ) { ?>
            <a href="<?php echo esc_url( $link_facebook ); ?>" target="_blank" class="item-social"><i class="ion ion-social-facebook"></i></a>
		<?php } ?>

		<?php if ( ! empty( $link_twitter ) ) { ?>
            <a href="<?php echo esc_url( $link_twitter ); ?>" target="_blank" class="item-social"><i class="ion ion-social-twitter"></i></a>

		<?php } ?>

		<?php if ( ! empty( $link_skype ) ) { ?>
            <a href="<?php echo esc_url( $link_skype ); ?>" target="_blank" class="item-social"><i class="fa fa-skype"></i></a>
		<?php } ?>

	</div>
<?php }

/**
 * Get about the author
 *
 * @return string
 */
if ( ! function_exists( 'thim_about_author' ) ) {
	function thim_about_author()
    {
        $user = new WP_User(get_the_author_meta('ID'));
        $link = get_author_posts_url(get_the_author_meta('ID'));
        if (get_the_author_meta('description')) {
            ?>
            <div class="thim-about-author author-blog">
                <div class="pic-author">
                    <div class="ava-author">
                        <a href="<?php echo esc_url($link); ?>">
                            <?php echo get_avatar(get_the_author_meta('ID'), 145); ?>
                        </a>
                    </div>

                    <?php thim_get_author_social_link(); ?>

                </div>

                <div class="text-author">
                    <div class="name-author">
                        <a href="<?php echo esc_url($link); ?>">
                            <?php echo get_the_author(); ?>
                        </a>
                    </div>

                    <?php if (!empty($user->roles)) {
                        echo '<div class="info-aothor role">' . esc_html($user->roles[0]) . '</div>';
                    } ?>


                    <div class="content-author author-description">
                        <?php echo wp_trim_words(get_the_author_meta('description'), 35); ?>
                    </div>
                </div>
            </div>
        <?php
        }
    }
}

add_action( 'thim_about_author', 'thim_about_author' );

function thim_post_share() {

	$sharings = get_theme_mod( 'group_sharing' );

	$icon_fb = '<i class="social-icon fa fa-facebook"></i>';
	$icon_tw = '<i class="social-icon fa fa-twitter"></i>';
	$icon_it = '<i class="social-icon fa fa-instagram"></i>';
	$icon_pr = '<i class="social-icon fa fa-pinterest"></i>';

	if ( isset( $sharings ) && $sharings ) {
		echo '<div class="socials">';
		foreach ( $sharings as $sharing ) {
			switch ( $sharing ) {
				case 'facebook':			
					echo '<div><a target="_blank" class="facebook item-social"  href="https://www.facebook.com/sharer.php?u=' . urlencode( get_permalink() ) . '" title="' . esc_attr__( 'Facebook', 'vividly' ) . '">'. $icon_fb .'</a></div>';
					break;
				case 'twitter':
					echo '<div><a target="_blank" class="twitter item-social" href="' . esc_url( 'https://twitter.com/share?url=' . urlencode( get_permalink() ) . '&amp;text=' . esc_attr( get_the_title() ) ) . '" title="' . esc_html__( 'Twitter', 'vividly' ) . '">'. $icon_tw .'</a></div>';
					break;
				case 'instagram':
					echo '<div><a target="_blank" class="instagram item-social" href="' . esc_url( 'https://www.instagram.com/share?url=' . urlencode( get_permalink() ) . '&amp;title=' . esc_attr( get_the_title() ) ) . '" title="' . esc_html__( 'Instagram', 'vividly' ) . '">'. $icon_it .'</a></div>';
					break;
				case 'pinterest':
					echo '<div><a target="_blank" class="pinterest item-social" href="' . esc_url( 'http://pinterest.com/pin/create/button/?url=' . urlencode( get_permalink() ) . '&amp;description=' . get_the_excerpt() . '&media=' . urlencode( wp_get_attachment_url( get_post_thumbnail_id() ) ) ) . '" onclick="window.open(this.href); return false;" title="' . esc_html__( 'Pinterest', 'vividly' ) . '">'. $icon_pr .'</a></div>';
					break;
			}
		}
		echo '</div>';
	}

}

add_action( 'thim_social_share', 'thim_post_share' );