<?php
define ( 'BP_AVATAR_FULL_WIDTH', 280 );
define ( 'BP_AVATAR_FULL_HEIGHT', 390 );

/**
 * @param $user
 */
if ( !function_exists( 'thim_extra_user_profile_fields' ) ) {
    function thim_extra_user_profile_fields( $user ) {
        $user_info = get_the_author_meta( 'thim_info', $user->ID );
        ?>
        <h3><?php esc_html_e( 'Profile', 'vividly' ); ?></h3>

        <table class="form-table">
            <tbody>
            <tr>
                <th>
                    <label for="thim_major"><?php esc_html_e( 'Major', 'vividly' ); ?></label>
                </th>
                <td>
                    <input id="thim_major" class="regular-text" type="text" value="<?php echo isset( $user_info['major'] ) ? $user_info['major'] : ''; ?>" name="thim_info[major]">
                </td>
            </tr>
            <tr>
                <th>
                    <label for="thim_birthday"><?php esc_html_e( 'Date of Birth', 'vividly' ); ?></label>
                </th>
                <td>
                    <input id="thim_birthday" class="regular-text" type="text" value="<?php echo isset( $user_info['birthday'] ) ? $user_info['birthday'] : ''; ?>" name="thim_info[birthday]">
                </td>
            </tr>
            <tr>
                <th>
                    <label for="thim_residence"><?php esc_html_e( 'Residence', 'vividly' ); ?></label>
                </th>
                <td>
                    <input id="thim_residence" class="regular-text" type="text" value="<?php echo isset( $user_info['residence'] ) ? $user_info['residence'] : ''; ?>" name="thim_info[residence]">
                </td>
            </tr>
            <tr>
                <th>
                    <label for="thim_country"><?php esc_html_e( 'Country', 'vividly' ); ?></label>
                </th>
                <td>
                    <input id="thim_country" class="regular-text" type="text" value="<?php echo isset( $user_info['country'] ) ? $user_info['country'] : ''; ?>" name="thim_info[country]">
                </td>
            </tr>
            <tr>
                <th>
                    <label for="thim_gender"><?php esc_html_e( 'Gender', 'vividly' ); ?></label>
                </th>
                <td>
                    <input id="thim_gender" class="regular-text" type="text" value="<?php echo isset( $user_info['gender'] ) ? $user_info['gender'] : ''; ?>" name="thim_info[gender]">
                </td>
            </tr>
            <tr>
                <th>
                    <label for="thim_language"><?php esc_html_e( 'Language', 'vividly' ); ?></label>
                </th>
                <td>
                    <input id="thim_language" class="regular-text" type="text" value="<?php echo isset( $user_info['language'] ) ? $user_info['language'] : ''; ?>" name="thim_info[language]">
                </td>
            </tr>
            <tr>
                <th>
                    <label for="thim_height"><?php esc_html_e( 'Height', 'vividly' ); ?></label>
                </th>
                <td>
                    <input id="thim_height" class="regular-text" type="text" value="<?php echo isset( $user_info['height'] ) ? $user_info['height'] : ''; ?>" name="thim_info[height]">
                </td>
            </tr>
            </tbody>
        </table>
        <?php
    }
}

add_action( 'show_user_profile', 'thim_extra_user_profile_fields' );
add_action( 'edit_user_profile', 'thim_extra_user_profile_fields' );

function thim_save_extra_user_profile_fields( $user_id ) {

    if ( !current_user_can( 'edit_user', $user_id ) ) {
        return false;
    }

    update_user_meta( $user_id, 'thim_info', $_POST['thim_info'] );
}

add_action( 'personal_options_update', 'thim_save_extra_user_profile_fields' );
add_action( 'edit_user_profile_update', 'thim_save_extra_user_profile_fields' );