<?php
/**
 * Section Footer Settings
 *
 */

// Add Section Footer Options
thim_customizer()->add_section(
	array(
		'id'       => 'footer_options',
		'title'    => esc_html__( 'Settings', 'vividly' ),
		'panel'    => 'footer',
		'priority' => 10,
	)
);


// Select Footer Layout
thim_customizer()->add_field(
    array(
        'id'            => 'footer_style',
        'type'          => 'radio-image',
        'label'         => esc_html__( 'Footer Layouts', 'vividly' ),
        'tooltip'     	=> esc_html__( 'Allows you can select footer layout for header on your site. ', 'vividly' ),
        'section'       => 'footer_options',
        'default'       => 'layout-1',
        'priority'      => 10,
        'choices'       => array(
            'layout-1'     => THIM_URI . 'assets/images/footer/layout-1.jpg',
            'layout-2'     => THIM_URI . 'assets/images/footer/layout-2.jpg',
            'layout-3'     => THIM_URI . 'assets/images/layout-3.png',
        ),
    )
);


// Enable or Disable Footer Widgets
thim_customizer()->add_field(
	array(
		'type'     => 'switch',
		'id'       => 'footer_widgets',
		'label'    => esc_html__( 'Show Footer Widgets', 'vividly' ),
		'tooltip'  => esc_html__( 'Turn on to display footer widgets.', 'vividly' ),
		'section'  => 'footer_options',
		'default'  => true,
		'priority' => 20,
		'choices'  => array(
			true  => esc_html__( 'On', 'vividly' ),
			false => esc_html__( 'Off', 'vividly' ),
		),
	)
);

// Footer Column Numbers
thim_customizer()->add_field(
	array(
		'type'            => 'slider',
		'id'              => 'footer_columns',
		'label'           => esc_html__( 'Sidebar Number', 'vividly' ),
		'tooltip'         => esc_html__( 'Controls the number of columns in the footer.', 'vividly' ),
		'section'         => 'footer_options',
		'default'         => 4,
		'priority' 		  => 30,
		'choices'         => array(
			'min'  => '1',
			'max'  => '6',
			'step' => '1',
		),
		'active_callback' => array(
			array(
				'setting'  => 'footer_widgets',
				'operator' => '==',
				'value'    => true,
			),
		),
	)
);

// Footer Background Color
thim_customizer()->add_field(
	array(
		'type'      => 'color',
		'id'        => 'footer_background_color',
		'label'     => esc_html__( 'Background Color', 'vividly' ),
		'section'   => 'footer_options',
		'default'   => '#FFFFFF',
		'priority'  => 40,
		'alpha'     => true,
		'transport' => 'postMessage',
		'js_vars'   => array(
			array(
				'element'  => 'footer#colophon .footer',
				'function' => 'css',
				'property' => 'background-color',
			),
		),
	)
);

// Upload Background Image
thim_customizer()->add_field(
    array(
        'id'       => 'footer_background_image',
        'type'     => 'image',
        'label'    => esc_html__( 'Background Image', 'vividly' ),
        'tooltip'  => esc_html__( 'You can upload image make to background image for footer. ', 'vividly' ),
        'section'  => 'footer_options',
        'priority' => 45,
    )
);

// Footer Text Color
thim_customizer()->add_field(
	array(
		'type'      => 'multicolor',
		'id'        => 'footer_color',
		'label'     => esc_html__( 'Colors', 'vividly' ),
		'section'   => 'footer_options',
		'priority'  => 50,
		'choices'   => array(
			'title' => esc_html__( 'Title', 'vividly' ),
			'text'  => esc_html__( 'Text', 'vividly' ),
			'link'  => esc_html__( 'Link', 'vividly' ),
			'hover' => esc_html__( 'Hover', 'vividly' ),
		),
		'default'   => array(
			'title' => '#333333',
			'text'  => '#666666',
			'link'  => '#333333',
			'hover' => '#c48981',
		),
		'transport' => 'postMessage',
		'js_vars'   => array(
			array(
				'choice'   => 'title',
				'element'  => 'footer#colophon h1, footer#colophon h2, footer#colophon h3, footer#colophon h4, footer#colophon h5, footer#colophon h6',
				'property' => 'color',
			),
			array(
				'choice'   => 'text',
				'element'  => 'footer#colophon',
				'property' => 'color',
			),
			array(
				'choice'   => 'link',
				'element'  => 'footer#colophon a',
				'property' => 'color',
			),
			array(
				'choice'   => 'hover',
				'element'  => 'footer#colophon a:hover',
				'property' => 'color',
			),
		),
	)
);