<?php
if ( ! defined( 'ABSPATH' ) ) {
  exit;
}
$user_id = get_current_user_id();
$display_name = get_the_author_meta('display_name', $rpost->post_author);
$pdate = get_the_time( get_option('date_format'), $rpost );
$current = strtotime(date("Y-m-d"));
$date    = strtotime( get_the_time('Y-m-d', $rpost) );

$datediff = $date - $current;
$difference = floor($datediff/(60*60*24));
if ( $difference == 0 ) {
  $date = esc_html__('Today', 'boxcar');
} elseif ( $difference == -1 ) {
  $date = esc_html__('Yesterday', 'boxcar');
}
?>
<li class="<?php echo esc_attr($rpost->post_author == $user_id ? 'yourself-reply' : 'user-reply'); ?> author-id-<?php echo esc_attr($rpost->post_author); ?>">
  <div class="d-flex align-items-center <?php esc_attr_e(($rpost->post_author == $user_id) ?'yourself-item flex-row-reverse':''); ?>">
    <div class="avatar">
      <?php boxcar_private_message_user_avatar( $rpost->post_author ); ?>
    </div>
    <div class="inner d-flex align-items-center">
      <?php if ( $rpost->post_author != $user_id ) { ?>
        <h4 class="user-name"><?php echo esc_html($display_name); ?></h4>
      <?php } else { ?>
        <h4 class="user-name"><?php echo esc_html__('You','boxcar') ?></h4>
      <?php } ?>
      <div class="post-date"><?php echo esc_html($pdate); ?>, <?php echo get_the_time( get_option('time_format'), $rpost ); ?></div>
    </div>
  </div>
  <div class="reply-content">
    <div class="post-content"><?php echo esc_html($rpost->post_content); ?></div>
  </div>
</li>