<?php
$post_format = get_post_format();
global $post;
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <div class="inner">
        <div class="entry-content-detail">

            <div class="single-info info-bottom">
                <div class="entry-description">
                    <?php
                        the_content();
                    ?>
                </div><!-- /entry-content -->
                <?php
                wp_link_pages( array(
                    'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'boxcar' ) . '</span>',
                    'after'       => '</div>',
                    'link_before' => '<span>',
                    'link_after'  => '</span>',
                    'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'boxcar' ) . ' </span>%',
                    'separator'   => '',
                ) );
                ?>
                <?php  
                    $posttags = get_the_tags();
                ?>
                <?php if( !empty($posttags) || boxcar_get_config('show_blog_social_share', false) ){ ?>
                    <div class="tag-social d-xl-flex align-items-center">

                        <?php if( boxcar_get_config('show_blog_social_share', false) ) { ?>
                            <?php get_template_part( 'template-parts/sharebox' ); ?>
                        <?php } ?>

                        <?php if(!empty($posttags)){ ?>
                            <div class="<?php echo esc_attr(boxcar_get_config('show_blog_social_share', false) ? 'ms-auto' : ''); ?>">
                                <?php boxcar_post_tags(); ?>
                            </div>
                        <?php } ?>
                    </div>
                <?php } ?>
            </div>

        </div>
    </div>
    <?php get_template_part( 'template-parts/author-bio' ); ?>
    <?php
        //Previous/next post navigation.
        the_post_navigation( array(
            'next_text' => 
                '<div class="inner">'.
                '<div class="navi">' . esc_html__( 'Next Post', 'boxcar' ) . ' <i class="flaticon-arrow-point-to-right"></i></div>'.
                '<span class="title-direct">%title</span></div>',
            'prev_text' => 
                '<div class="inner">'.
                '<div class="navi"><i class="flaticon-arrowhead-thin-outline-to-the-left"></i> ' . esc_html__( 'Previous Post', 'boxcar' ) . '</div>'.
                '<span class="title-direct">%title</span></div>',
        ) );
    ?>
</article>