<?php 
global $post;
$thumbsize = !isset($args['thumbsize']) ? boxcar_get_config( 'blog_item_thumbsize', 'full' ) : $args['thumbsize'];
$thumb = boxcar_display_post_thumb($thumbsize);
?>
<article <?php post_class('post post-layout post-grid-v3'); ?>>
    <div class="clearfix">
        <?php
            if ( !empty($thumb) ) {
                ?>
                <div class="top-image">
                    <?php
                        echo trim($thumb);
                    ?>
                 </div>
                <?php
            }
        ?>
        <div class="col-content">
            <?php if (get_the_title()) { ?>
                <h4 class="entry-title">
                    <?php if ( is_sticky() && is_home() && ! is_paged() ) : ?>
                        <div class="stick-icon"><i class="ti-pin2"></i></div>
                    <?php endif; ?>
                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                </h4>
            <?php } ?>
            <div class="description"><?php echo boxcar_substring( get_the_excerpt(),10, '' ); ?></div>
            <div class="more-bottom">
                        <a href="<?php the_permalink(); ?>" class="btn-readmore"><?php echo esc_html__( 'Explore More', 'boxcar' )?><svg xmlns="http://www.w3.org/2000/svg" class="next" width="14" height="14" viewBox="0 0 14 14" fill="none">
            <path d="M13.6109 0H5.05533C4.84037 0 4.66643 0.173943 4.66643 0.388901C4.66643 0.603859 4.84037 0.777802 5.05533 0.777802H12.6721L0.113697 13.3362C-0.0382246 13.4881 -0.0382246 13.7342 0.113697 13.8861C0.18964 13.962 0.289171 14 0.388666 14C0.488161 14 0.587656 13.962 0.663635 13.8861L13.222 1.3277V8.94447C13.222 9.15943 13.3959 9.33337 13.6109 9.33337C13.8259 9.33337 13.9998 9.15943 13.9998 8.94447V0.388901C13.9998 0.173943 13.8258 0 13.6109 0Z" fill="currentColor"/>
            </svg></a>
            </div>
        </div>
    </div>
</article>