<?php
global $post;
wp_enqueue_script('addthis');

$img = '';
if ( has_post_thumbnail() ) {
	$img = get_the_post_thumbnail_url($post->ID, 'full');
}

?>
<div class="apus-social-share">
	<div class="bo-social-icons bo-sicolor social-radius-rounded">
		<strong class="share-title"><?php esc_html_e('Share this post', 'boxcar'); ?></strong>
		<?php if ( boxcar_get_config('facebook_share', 1) ): ?>
 
			<a class="facebook" data-toggle="tooltip" href="https://www.facebook.com/sharer.php?s=100&u=<?php the_permalink(); ?>&i=<?php echo urlencode($img); ?>" target="_blank" title="<?php esc_attr_e('Share on facebook', 'boxcar'); ?>">
				<i class="fab fa-facebook-f"></i>
			</a>
 
		<?php endif; ?>
		<?php if ( boxcar_get_config('twitter_share', 1) ): ?>
			<a class="twitter" data-toggle="tooltip" href="https://twitter.com/intent/tweet?url=<?php the_permalink(); ?>" target="_blank" title="<?php esc_attr_e('Share on Twitter', 'boxcar'); ?>">
				<i class="fab fa-twitter"></i>
			</a>
 
		<?php endif; ?>
		<?php if ( boxcar_get_config('linkedin_share', 1) ): ?>
 
			<a class="linkedin"  data-toggle="tooltip" href="https://linkedin.com/shareArticle?mini=true&amp;url=<?php the_permalink(); ?>&amp;title=<?php the_title(); ?>" target="_blank" title="<?php esc_attr_e('Share on LinkedIn', 'boxcar'); ?>">
				<i class="fab fa-linkedin-in"></i>
			</a>
 
		<?php endif; ?>

		<?php if ( boxcar_get_config('pinterest_share', 1) ): ?>
 
			<a class="pinterest" data-toggle="tooltip" href="https://pinterest.com/pin/create/button/?url=<?php echo urlencode(get_permalink()); ?>&amp;media=<?php echo urlencode($img); ?>" target="_blank" title="<?php esc_attr_e('Share on Pinterest', 'boxcar'); ?>">
				<i class="fab fa-pinterest-p"></i>
			</a>
 
		<?php endif; ?>
	</div>
</div>