<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
boxcar_load_select2();
?>

<?php $my_listings_page_id = wp_cardealer_get_option('my_listings_page_id'); ?>

<h1 class="title-profile"><?php esc_html_e( 'My Listings', 'boxcar' ) ; ?></h1>

<?php
	$paged = (get_query_var( 'paged' )) ? get_query_var( 'paged' ) : 1;
	$query_vars = array(
		'post_type'     => 'listing',
		'post_status'   => apply_filters('wp-cardealer-my-listings-post-statuses', array( 'publish', 'expired', 'pending', 'pending_approve', 'pending_payment', 'draft', 'preview' )),
		'paged'         => $paged,
		'author'        => get_current_user_id(),
		'orderby'		=> 'date',
		'order'			=> 'DESC',
	);
	if ( isset($_GET['search']) ) {
		$query_vars['s'] = $_GET['search'];
	}
	if ( isset($_GET['orderby']) ) {
		switch ($_GET['orderby']) {
			case 'menu_order':
				$query_vars['orderby'] = array(
					'menu_order' => 'ASC',
					'date'       => 'DESC',
					'ID'         => 'DESC',
				);
				break;
			case 'newest':
				$query_vars['orderby'] = 'date';
				$query_vars['order'] = 'DESC';
				break;
			case 'oldest':
				$query_vars['orderby'] = 'date';
				$query_vars['order'] = 'ASC';
				break;
		}
	}
	$listings = new WP_Query($query_vars);

?>
<div class="box-white-dashboard">

	<div class="space-bottom-30">
		<div class="d-md-flex align-items-center top-dashboard-search">
			<div class="search-my-listings-form widget-search search-listings-form">
				<form action="<?php echo esc_url(get_permalink( $my_listings_page_id )); ?>" method="get">
					<div class="d-flex align-items-center">
						<button class="search-submit btn btn-search" name="submit">
							<i class="flaticon-search"></i>
						</button>
						<input placeholder="<?php esc_attr_e('Search ...', 'boxcar'); ?>" class="form-control" type="text" name="search" value="<?php echo esc_attr(isset($_GET['search']) ? $_GET['search'] : ''); ?>">
					</div>
				</form>
			</div>
			<div class="sort-my-listings-form sortby-form ms-auto">
				<?php
					$orderby_options = apply_filters( 'wp_cardealer_my_listings_orderby', array(
						'menu_order'	=> esc_html__( 'Default', 'boxcar' ),
						'newest' 		=> esc_html__( 'Newest', 'boxcar' ),
						'oldest'     	=> esc_html__( 'Oldest', 'boxcar' ),
					) );

					$orderby = isset( $_GET['orderby'] ) ? wp_unslash( $_GET['orderby'] ) : 'newest'; 
				?>

				<div class="orderby-wrapper d-flex align-items-center">
					<span class="text-sort">
						<?php echo esc_html__('Sort by: ','boxcar'); ?>
					</span>
					<form class="my-listings-ordering" method="get">
						<select name="orderby" class="orderby">
							<?php foreach ( $orderby_options as $id => $name ) : ?>
								<option value="<?php echo esc_attr( $id ); ?>" <?php selected( $orderby, $id ); ?>><?php echo esc_html( $name ); ?></option>
							<?php endforeach; ?>
						</select>
						<input type="hidden" name="paged" value="1" />
						<?php WP_CarDealer_Mixes::query_string_form_fields( null, array( 'orderby', 'submit', 'paged' ) ); ?>
					</form>
				</div>
			</div>
		</div>
	</div>

	<div class="inner">
		<div class="layout-my-listings d-flex align-items-center header-layout">
			<div class="listing-thumbnail-wrapper d-none d-md-block">
				<?php echo esc_html__('Image','boxcar') ?>
			</div>
			<div class="layout-left d-flex align-items-center inner-info flex-grow-1">
				<div class="inner-info-left">
					<?php echo esc_html__('Information','boxcar') ?>
				</div>
				<div class="d-none d-md-block">
					<?php echo esc_html__('Expiry','boxcar') ?>
				</div>
				<div class="d-none d-md-block">
					<?php echo esc_html__('Status','boxcar') ?>
				</div>
				<div class="d-none d-md-block">
					<?php echo esc_html__('View','boxcar') ?>
				</div>
				<div>
					<?php echo esc_html__('Action','boxcar') ?>
				</div>
			</div>
		</div>
		<?php if ( $listings->have_posts() ) : ?>
			<?php while ( $listings->have_posts() ) : $listings->the_post(); global $post; ?>

				<div class="my-listings-item listing-item">
					<div class="d-flex align-items-center layout-my-listings">
						<div class="listing-thumbnail-wrapper d-none d-md-block">
							<?php boxcar_listing_display_image( $post, 'boxcar-listing-list' ); ?>
							<?php $is_featured = get_post_meta( $post->ID, WP_CARDEALER_LISTING_PREFIX . 'featured', true ); ?>
							<div class="top-label">
								<?php if ( $is_featured ) : ?>
									<span class="featured-listing"><?php echo esc_html__('Featured','boxcar') ?></span>
								<?php endif; ?>
							</div>
						</div>
						<div class="inner-info flex-grow-1 d-flex align-items-center layout-left">
							<div class="inner-info-left">
								<h3 class="listing-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
								<?php $tagline = boxcar_listing_display_meta($post, 'tagline', '', false); ?>
								<?php echo trim($tagline); ?>
	            				<?php boxcar_listing_display_price($post, 'no-icon-title', true); ?>
							</div>
							<div class="listing-info-date-expiry d-none d-md-block">
								<div class="listing-table-info-content-expiry">
									<?php
										$expires = get_post_meta( $post->ID, WP_CARDEALER_LISTING_PREFIX.'expiry_date', true);
										if ( $expires ) {
											echo '<span>' . esc_html( date_i18n( get_option( 'date_format' ), strtotime( $expires ) ) ) . '</span>';
										} else {
											echo '--';
										}
									?>
								</div>
							</div>
							<div class="status-listing-wrapper d-none d-md-block">
								<span class="status-listing <?php echo esc_attr($post->post_status); ?>">
									<?php
										$post_status = get_post_status_object( $post->post_status );
										if ( !empty($post_status->label) ) {
											echo esc_html($post_status->label);
										} else {
											echo esc_html($post->post_status);
										}
									?>
								</span>
							</div>
							<div class="view-listing-wrapper d-none d-md-block">
								<?php
									$views = get_post_meta($post->ID, WP_CARDEALER_LISTING_PREFIX.'views', true);
									echo WP_CarDealer_Mixes::format_number($views);
								?>
							</div>
							<div class="warpper-action-listing">

								<?php
								$my_listings_page_url = get_permalink( $my_listings_page_id );
								$my_listings_page_url = add_query_arg( 'listing_id', $post->ID, remove_query_arg( 'listing_id', $my_listings_page_url ) );
								switch ( $post->post_status ) {
									case 'publish' :
										$edit_url = add_query_arg( 'action', 'edit', remove_query_arg( 'action', $my_listings_page_url ) );
										
										$edit_able = wp_cardealer_get_option('user_edit_published_submission');
										if ( $edit_able !== 'no' ) {
										?>
											<a data-toggle="tooltip" href="<?php echo esc_url($edit_url); ?>" class="edit-btn btn-action-icon edit  job-table-action" title="<?php esc_attr_e('Edit', 'boxcar'); ?>">
												<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
<path d="M14.7998 15.1852H10.0171C9.70659 15.1852 9.45459 14.9332 9.45459 14.6227C9.45459 14.3122 9.70659 14.0602 10.0171 14.0602H14.7998C15.1103 14.0602 15.3623 14.3122 15.3623 14.6227C15.3623 14.9332 15.1103 15.1852 14.7998 15.1852Z" fill="currentColor"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M12.0436 8.39385L12.964 7.16767C13.42 6.56017 13.612 5.81168 13.5048 5.05942C13.3975 4.30717 13.0045 3.64267 12.397 3.18667C11.1438 2.24617 9.35727 2.49892 8.41602 3.75367L3.35201 10.4999C1.84301 12.5122 3.18551 14.9092 3.24326 15.0104C3.32126 15.1462 3.45251 15.2429 3.60551 15.2782C3.64901 15.2887 4.06901 15.3817 4.65476 15.3817C5.60201 15.3817 6.98051 15.1394 7.90002 13.9139L11.9265 8.54993C11.9499 8.52788 11.9717 8.50358 11.9916 8.47703C12.0117 8.4504 12.029 8.42258 12.0436 8.39385ZM4.10801 14.2214C4.69376 14.2927 6.17126 14.3429 7.00001 13.2382L10.7471 8.24633L7.99857 6.18272L4.25126 11.1749C3.40601 12.3029 3.87101 13.6837 4.10801 14.2214ZM8.67372 5.28337L11.4226 7.34636L12.064 6.49192C12.6333 5.73443 12.4795 4.65517 11.722 4.08592C10.9638 3.51817 9.88377 3.67193 9.31527 4.42867L8.67372 5.28337Z" fill="currentColor"/>
</svg>
											</a>
										<?php } ?>
										<?php
										break;
									case 'expired' :
										$relist_url = add_query_arg( 'action', 'relist', remove_query_arg( 'action', $my_listings_page_url ) );
										?>
										<a data-toggle="tooltip" href="<?php echo esc_url($relist_url); ?>" class="btn-action-icon view  job-table-action" title="<?php esc_attr_e('Relist', 'boxcar'); ?>">
											<i class="ti-eye"></i>
										</a>
										<?php
										break;
									case 'pending_payment':
										$order_id = get_post_meta($post->ID, WP_CARDEALER_LISTING_PREFIX.'order_id', true);
										if ( $order_id ) {
											$edit_able = wp_cardealer_get_option('user_edit_published_submission');
											if ( $edit_able !== 'no' ) {
												$edit_url = add_query_arg( 'action', 'edit', remove_query_arg( 'action', $my_listings_page_url ) );
												?>
												<a data-toggle="tooltip" href="<?php echo esc_url($edit_url); ?>" class="edit-btn btn-action-icon edit  job-table-action" title="<?php esc_attr_e('Edit', 'boxcar'); ?>">
													<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
<path d="M14.7998 15.1852H10.0171C9.70659 15.1852 9.45459 14.9332 9.45459 14.6227C9.45459 14.3122 9.70659 14.0602 10.0171 14.0602H14.7998C15.1103 14.0602 15.3623 14.3122 15.3623 14.6227C15.3623 14.9332 15.1103 15.1852 14.7998 15.1852Z" fill="currentColor"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M12.0436 8.39385L12.964 7.16767C13.42 6.56017 13.612 5.81168 13.5048 5.05942C13.3975 4.30717 13.0045 3.64267 12.397 3.18667C11.1438 2.24617 9.35727 2.49892 8.41602 3.75367L3.35201 10.4999C1.84301 12.5122 3.18551 14.9092 3.24326 15.0104C3.32126 15.1462 3.45251 15.2429 3.60551 15.2782C3.64901 15.2887 4.06901 15.3817 4.65476 15.3817C5.60201 15.3817 6.98051 15.1394 7.90002 13.9139L11.9265 8.54993C11.9499 8.52788 11.9717 8.50358 11.9916 8.47703C12.0117 8.4504 12.029 8.42258 12.0436 8.39385ZM4.10801 14.2214C4.69376 14.2927 6.17126 14.3429 7.00001 13.2382L10.7471 8.24633L7.99857 6.18272L4.25126 11.1749C3.40601 12.3029 3.87101 13.6837 4.10801 14.2214ZM8.67372 5.28337L11.4226 7.34636L12.064 6.49192C12.6333 5.73443 12.4795 4.65517 11.722 4.08592C10.9638 3.51817 9.88377 3.67193 9.31527 4.42867L8.67372 5.28337Z" fill="currentColor"/>
</svg>
												</a>
												<?php
											}
										} else {
											$continue_url = add_query_arg( 'action', 'continue', remove_query_arg( 'action', $my_listings_page_url ) );
											?>
											<a data-toggle="tooltip" href="<?php echo esc_url($continue_url); ?>" class="edit-btn btn-action-icon edit  job-table-action" title="<?php esc_attr_e('Continue', 'boxcar'); ?>">
												<i class=" ti-arrow-top-right"></i>
											</a>
											<?php
										}
										break;
									case 'pending_approve':
									case 'pending' :
										$edit_able = wp_cardealer_get_option('user_edit_published_submission');
										if ( $edit_able !== 'no' ) {
											$edit_url = add_query_arg( 'action', 'edit', remove_query_arg( 'action', $my_listings_page_url ) );
											?>
											<a data-toggle="tooltip" href="<?php echo esc_url($edit_url); ?>" class="edit-btn btn-action-icon edit  job-table-action" title="<?php esc_attr_e('Edit', 'boxcar'); ?>">
												<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
<path d="M14.7998 15.1852H10.0171C9.70659 15.1852 9.45459 14.9332 9.45459 14.6227C9.45459 14.3122 9.70659 14.0602 10.0171 14.0602H14.7998C15.1103 14.0602 15.3623 14.3122 15.3623 14.6227C15.3623 14.9332 15.1103 15.1852 14.7998 15.1852Z" fill="currentColor"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M12.0436 8.39385L12.964 7.16767C13.42 6.56017 13.612 5.81168 13.5048 5.05942C13.3975 4.30717 13.0045 3.64267 12.397 3.18667C11.1438 2.24617 9.35727 2.49892 8.41602 3.75367L3.35201 10.4999C1.84301 12.5122 3.18551 14.9092 3.24326 15.0104C3.32126 15.1462 3.45251 15.2429 3.60551 15.2782C3.64901 15.2887 4.06901 15.3817 4.65476 15.3817C5.60201 15.3817 6.98051 15.1394 7.90002 13.9139L11.9265 8.54993C11.9499 8.52788 11.9717 8.50358 11.9916 8.47703C12.0117 8.4504 12.029 8.42258 12.0436 8.39385ZM4.10801 14.2214C4.69376 14.2927 6.17126 14.3429 7.00001 13.2382L10.7471 8.24633L7.99857 6.18272L4.25126 11.1749C3.40601 12.3029 3.87101 13.6837 4.10801 14.2214ZM8.67372 5.28337L11.4226 7.34636L12.064 6.49192C12.6333 5.73443 12.4795 4.65517 11.722 4.08592C10.9638 3.51817 9.88377 3.67193 9.31527 4.42867L8.67372 5.28337Z" fill="currentColor"/>
</svg>
											</a>
											<?php
										}
									break;
									case 'draft' :
									case 'preview' :
										$continue_url = add_query_arg( 'action', 'continue', remove_query_arg( 'action', $my_listings_page_url ) );
										?>
										<a data-toggle="tooltip" href="<?php echo esc_url($continue_url); ?>" class="edit-btn btn-action-icon edit  job-table-action" title="<?php esc_attr_e('Continue', 'boxcar'); ?>">
											<i class="ti-arrow-top-right"></i>
										</a>
										<?php
										break;
								}
								?>

								<a data-toggle="tooltip" class="remove-btn btn-action-icon listing-table-action listing-button-delete" href="javascript:void(0)" data-listing_id="<?php echo esc_attr($post->ID); ?>" data-nonce="<?php echo esc_attr(wp_create_nonce( 'wp-cardealer-delete-listing-nonce' )); ?>" title="<?php esc_attr_e('Remove', 'boxcar'); ?>">
									<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
<path fill-rule="evenodd" clip-rule="evenodd" d="M7.06907 7.69027C7.37819 7.65937 7.65382 7.8849 7.68472 8.19405L8.05972 11.944C8.0907 12.2531 7.8651 12.5288 7.55602 12.5597C7.2469 12.5906 6.97124 12.3651 6.94033 12.0559L6.56533 8.30595C6.53442 7.99687 6.75995 7.72117 7.06907 7.69027Z" fill="currentColor"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M10.931 7.69027C11.2401 7.72117 11.4656 7.99687 11.4347 8.30595L11.0597 12.0559C11.0288 12.3651 10.7532 12.5906 10.444 12.5597C10.135 12.5288 9.90943 12.2531 9.94033 11.944L10.3153 8.19405C10.3462 7.8849 10.6219 7.65937 10.931 7.69027Z" fill="currentColor"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M7.59285 0.937514H10.129C10.2913 0.937409 10.4327 0.937319 10.5662 0.958642C11.0936 1.04287 11.5501 1.37186 11.7968 1.84563C11.8592 1.96555 11.9039 2.09971 11.9551 2.2537L12.0388 2.50488C12.053 2.5474 12.057 2.55943 12.0605 2.56891C12.1918 2.932 12.5323 3.17744 12.9183 3.18723C12.9284 3.18748 12.9409 3.18753 12.9859 3.18753H15.2359C15.5466 3.18753 15.7984 3.43936 15.7984 3.75003C15.7984 4.06069 15.5466 4.31253 15.2359 4.31253H2.48584C2.17518 4.31253 1.92334 4.06069 1.92334 3.75003C1.92334 3.43936 2.17518 3.18753 2.48584 3.18753H4.73591C4.78094 3.18753 4.79336 3.18748 4.80352 3.18723C5.18951 3.17744 5.53002 2.93202 5.66136 2.56893C5.66481 2.55938 5.66879 2.54761 5.68303 2.50488L5.76673 2.25372C5.81796 2.09973 5.86259 1.96555 5.92503 1.84563C6.17174 1.37186 6.62819 1.04287 7.15566 0.958642C7.28918 0.937319 7.43057 0.937409 7.59285 0.937514ZM6.61695 3.18753C6.65558 3.11176 6.68982 3.03303 6.71927 2.95161C6.72821 2.92688 6.73699 2.90056 6.74825 2.86675L6.82311 2.64219C6.89149 2.43706 6.90723 2.39522 6.92285 2.36523C7.00508 2.2073 7.15724 2.09764 7.33306 2.06956C7.36646 2.06423 7.41111 2.06253 7.62735 2.06253H10.0945C10.3107 2.06253 10.3553 2.06423 10.3888 2.06956C10.5646 2.09764 10.7168 2.2073 10.799 2.36523C10.8146 2.39522 10.8303 2.43705 10.8987 2.64219L10.9735 2.86662L11.0026 2.95162C11.032 3.03304 11.0663 3.11176 11.1049 3.18753H6.61695Z" fill="currentColor"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M3.83761 5.81377C4.14757 5.7931 4.41561 6.02763 4.43628 6.3376L4.78123 11.5119C4.84862 12.5228 4.89664 13.2262 5.00207 13.7554C5.10433 14.2688 5.24708 14.5405 5.45215 14.7323C5.6572 14.9241 5.93782 15.0485 6.45682 15.1164C6.99187 15.1864 7.6969 15.1875 8.71 15.1875H9.29004C10.3031 15.1875 11.0081 15.1864 11.5432 15.1164C12.0622 15.0485 12.3428 14.9241 12.5479 14.7323C12.7529 14.5405 12.8957 14.2688 12.998 13.7554C13.1034 13.2262 13.1514 12.5228 13.2188 11.5119L13.5638 6.3376C13.5844 6.02763 13.8524 5.7931 14.1624 5.81377C14.4724 5.83443 14.7069 6.10246 14.6863 6.41244L14.3387 11.6262C14.2745 12.5883 14.2228 13.3654 14.1013 13.9752C13.975 14.6092 13.7602 15.1388 13.3165 15.5538C12.8728 15.9689 12.3301 16.148 11.6891 16.2319C11.0726 16.3125 10.2938 16.3125 9.32957 16.3125H8.67047C7.70627 16.3125 6.92743 16.3125 6.3109 16.2319C5.66991 16.148 5.12725 15.9689 4.68356 15.5538C4.23986 15.1388 4.02505 14.6092 3.89875 13.9752C3.77727 13.3654 3.72547 12.5883 3.66136 11.6262L3.31377 6.41244C3.2931 6.10246 3.52763 5.83443 3.83761 5.81377Z" fill="currentColor"/>
</svg>
								</a>
							</div>
						</div>
					</div>

				</div>
			<?php endwhile; ?>
			<?php
				WP_CarDealer_Mixes::custom_pagination( array(
					'max_num_pages' => $listings->max_num_pages,
					'prev_text'     => '<i class="flaticon-arrowhead-thin-outline-to-the-left"></i>',
					'next_text'     => '<i class="flaticon-arrow-point-to-right"></i>',
					'wp_query' 		=> $listings
				));
				
				wp_reset_postdata();
			?>
		<?php else : ?>
			<div class="alert alert-warning">
				<p><?php esc_html_e( 'You don\'t have any listings yet. Start by creating new one.', 'boxcar' ); ?></p>
			</div>
		<?php endif; ?>
	</div>
</div>