<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
global $post;

$columns = boxcar_get_config('user_listings_columns', 4);

$limit = boxcar_get_config('user_listings_number', 4);

$args = array(
    'post_type' => 'listing',
    'posts_per_page' => $limit,
    'author' => $author_obj->ID
);
$listings = new WP_Query( $args );
if( $listings->have_posts() ):
?>
    <div id="user-listings-wrapper" class="wrapper-listings-related">
        <div class="container">
            <div class="related-listings">
                <div class="top-related">
                    <h4 class="title">
                        <?php esc_html_e( 'My Listings', 'boxcar' ); ?>
                    </h4>
                </div>
                <div class="widget-content">
                    <div class="slick-carousel" data-carousel="slick" data-smallmedium="2" data-extrasmall="1" data-items="<?php echo esc_attr($columns); ?>" data-pagination="false" data-nav="true">
                        <?php while ( $listings->have_posts() ) : $listings->the_post(); ?>
                            <div class="item">
                                <?php echo WP_CarDealer_Template_Loader::get_template_part( 'listings-styles/inner-grid' ); ?>
                            </div>
                        <?php endwhile; ?>
                    </div>
                    <?php wp_reset_postdata(); ?>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>