<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$address = get_user_meta($author_obj->ID, '_user_address', true);
$phone = get_user_meta($author_obj->ID, '_user_phone', true);
$email = !empty($author_obj->user_email) ? $author_obj->user_email : '';
?>
<div class="listing-user-header top-header-user-listing">
    <div class="row flex-middle-lg flex-middle-md">
        <div class="col-xs-12 col-md-8">
            <div class="left-info flex-middle-sm">
                <div class="listing-user-avarta">
                    <?php echo get_avatar($author_obj->ID, 100); ?>
                </div>
                <div class="listing-user-info">
                    <h1 class="title"><?php echo esc_html($author_obj->display_name); ?></h1>

                    <div class="listing-user-metas flex-middle-sm">
                        <?php if ( !empty($phone) ) { ?>
                            <div class="phone"><i class="flaticon-phone-receiver-silhouette"></i> <span><?php echo esc_attr($phone); ?></span></div>
                        <?php } ?>
                        <?php if ( !empty($address) ) { ?>
                            <div class="address"><i class="flaticon-pin"></i> <span><?php echo esc_attr($address); ?></span></div>
                        <?php } ?>
                        <?php if ( !empty($email) ) { ?>
                            <div class="email"><i class="flaticon-email"></i> <span><?php echo esc_attr($email); ?></span></div>
                        <?php } ?>
                    </div>

                </div>
            </div>
        </div>
        <div class="col-xs-12 col-md-4">
            <div class="listing-action-user">
                <?php
                if ( boxcar_get_config('show_user_listings', true) ) {
                ?>
                    <a href="#" class="btn btn-second btn-block view-user-cars-btn"><?php echo esc_html__('View cars', 'boxcar'); ?></a>
                <?php } ?>
            </div>
        </div>
    </div>
</div>