<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
$gallery = get_user_meta($author_obj->ID, '_user_photos', true);

if ( has_post_thumbnail() || $gallery ) {
    $gallery_size = !empty($gallery_size) ? $gallery_size : 'boxcar-gallery-large';
    $thumbs_pos = !empty($thumbs_pos) ? $thumbs_pos : 'horizontal';
    $nb_columns = !empty($nb_columns) ? $nb_columns : 5;
?>
<div class="listing-detail-gallery clearfix vertical">
    
    <div class="listing-single-gallery-wrapper">
        <div class="slick-carousel gap-10 listing-single-gallery" data-carousel="slick" data-items="1" data-smallmedium="1" data-extrasmall="1" data-pagination="false" data-nav="true" data-slickparent="true">
            <?php if ( $gallery ) {
                foreach ( $gallery as $id => $src ) {
                ?>
                    <a href="<?php echo esc_url( $src ); ?>" data-elementor-lightbox-slideshow="boxcar-gallery" class="p-popup-image">
                        <?php echo boxcar_get_attachment_thumbnail( $id, $gallery_size ); ?>
                    </a>
                <?php }
            } ?>
        </div>
    </div>

    <div class="wrapper-thumbs">
        <div class="slick-carousel gap-10 listing-single-gallery-thumbs vertical" data-carousel="slick" data-items="<?php echo esc_attr($nb_columns); ?>" data-smallmedium="<?php echo esc_attr($nb_columns); ?>" data-extrasmall="2" data-smallest="2" data-pagination="false" data-nav="true" data-asnavfor=".listing-single-gallery" data-slidestoscroll="1" data-focusonselect="true" data-vertical="true">
            
            <?php if ( $gallery ) {
                foreach ( $gallery as $id => $src ) {
                ?>
                    <div class="p-popup-image">
                        <?php echo boxcar_get_attachment_thumbnail( $id, 'boxcar-gallery-thumbs' ); ?>
                    </div>
                <?php }
            } ?>
        </div>
    </div>
</div>
<?php }