<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
global $post;

if ( ! comments_open() ) {
	return;
}

?>
<?php if ( have_comments() ) : ?>
	
	<div id="comments">
		<div class="review-title-wrapper">
			<?php if ( WP_CarDealer_Review::review_enable() ) { ?>
				<h3 class="comments-title">
					<?php
						comments_number( esc_html__('0 Reviews', 'boxcar'), esc_html__('1 Review', 'boxcar'), esc_html__('% Reviews', 'boxcar') );
					?>
				</h3>
			<?php } else { ?>
				<h3 class="comments-title">
					<?php comments_number( esc_html__('0 Comments', 'boxcar'), esc_html__('1 Comment', 'boxcar'), esc_html__('% Comments', 'boxcar') ); ?>
				</h3>
			<?php } ?>
		</div>
		
		<?php if ( WP_CarDealer_Review::review_enable() ) {

			$nb_reviews = WP_CarDealer_Review::get_total_reviews($post->ID);
			$rating = get_post_meta( $post->ID, '_average_rating', true );
			$rating_remain = 5 - $rating;
			?>
			<div class="reviews-total d-lg-flex align-items-center">
				<div class="col-lg-3">
					<div class="review-average text-center position-relative">
						<?php
							$bg_color = apply_filters('review_calculator_bg_color', '#E9F2FF');
							$color = apply_filters('review_calculator_color', '#405FF2');
						?>
						<canvas class="review-calculator-chart" id="review-calculator-chart" width="220" height="220" data-bg_color="<?php echo esc_attr($bg_color); ?>" data-color="<?php echo esc_attr($color); ?>" data-rating="<?php echo esc_attr($rating); ?>" data-rating_remain="<?php echo esc_attr($rating_remain); ?>"></canvas>
						<div class="inner text-theme">
							<div><?php esc_html_e('Overral Rating', 'boxcar'); ?></div>
							<div class="number_average"><?php echo number_format($rating, 1); ?></div>
							<div class="coefficient_rating"><?php esc_html_e('Out of 5', 'boxcar'); ?></div>
						</div>
					</div>
				</div>
				<div class="reviews-category col-lg-9">
					<?php
					$reviews = get_post_meta( $post->ID, '_average_ratings', true );
					$categories = wp_cardealer_get_option('listing_review_category');

					if ( !empty($categories) ) { ?>
						<div class="list-category-rating d-md-flex flex-wrap">
				    		<?php foreach ($categories as $category) {
					            $rate = isset($reviews[$category['key']]) ? $reviews[$category['key']] : 0;
					            if ($rate >= 5) {
									$trust = esc_html__('Perfect', 'boxcar');
								} elseif ($rate >= 4) {
									$trust = esc_html__('Good', 'boxcar');
								} elseif ($rate >= 3) {
									$trust = esc_html__('Average', 'boxcar');
								} elseif ($rate == 2) {
									$trust = esc_html__('Not that bad', 'boxcar');
								} else {
									$trust = esc_html__('Very Poor', 'boxcar');
								}
					            ?>
					            <div class="rating-inner d-flex align-items-center col-md-6 col-12">
					            	<div class="category-label">
					            		<?php echo !empty($category['name']) ? $category['name'] : ''; ?>
					            		<div class="trust"><?php echo esc_html($trust); ?></div>
					            	</div>
					            	<div class="ms-auto d-flex align-items-center category-value">
						                <div class="percent-wrapper">
						                	<div class="percent" style="<?php echo esc_attr( 'width: ' . ( $rate * 20 ) . '%' ) ?>"></div>
						                </div>
						                <div class="value">
						                	<i class="fas fa-star text-theme"></i><?php echo number_format(round($rate, 2),1); ?>
						                </div>
					                </div>
					            </div>
					        <?php } ?>
				        </div>
			    	<?php } ?>
		    	</div>
	    	</div>
		<?php } ?>

		<ol class="comment-list">
			<?php wp_list_comments( array( 'callback' => array( 'WP_CarDealer_Review', 'listing_comments' ) ) ); ?>
		</ol>

		<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
			echo '<nav class="apus-pagination">';
			paginate_comments_links( apply_filters( 'wp_cardealer_comment_pagination_args', array(
				'prev_text' => '&larr;',
				'next_text' => '&rarr;',
				'type'      => 'list',
			) ) );
			echo '</nav>';
		endif; ?>
		
	</div>
<?php endif; ?>

<div id="reviews">

	<?php $commenter = wp_get_current_commenter(); ?>
	<div id="review_form_wrapper">
		<div id="review_form">
			<?php
				$comment_form = array(
					'title_reply'          => have_comments() ? esc_html__( 'Add a review', 'boxcar' ) : sprintf( esc_html__( 'Be the first to review &ldquo;%s&rdquo;', 'boxcar' ), get_the_title() ),
					'title_reply_to'       => esc_html__( 'Leave a Reply to %s', 'boxcar' ),
					'comment_notes_before' => '',
					'comment_notes_after'  => '',
					'fields'               => array(
						'author' => '<div class="row row-20"><div class="col-12 col-md-6"><div class="form-group">'.
									'<label>'.esc_attr__( 'Name', 'boxcar' ).'</label>'.
						            '<input id="author" class="form-control" name="author" placeholder="'.esc_attr__( 'Ali...', 'boxcar' ).'" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30" aria-required="true" /></div></div>',
						'email'  => '<div class="col-12 col-md-6"><div class="form-group">' .
									'<label>'.esc_attr__( 'Email', 'boxcar' ).'</label>'.
						            '<input id="email" class="form-control" name="email" placeholder="'.esc_attr__( 'Example...', 'boxcar' ).'" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30" aria-required="true" /></div></div></div>',
					),
					'label_submit'  => esc_html__( 'Submit Review', 'boxcar' ),
					'logged_in_as'  => '',
					'comment_field' => '',
					'title_reply_before' => '<h4 class="title comment-reply-title">',
					'title_reply_after'  => '</h4>',
					'class_submit' => 'btn btn-theme'
				);

				$comment_form['must_log_in'] = '<div class="must-log-in">' .esc_html__( 'You must be logged in to post a review.', 'boxcar' ) . '</div>';
				
				$comment_form['comment_field'] .= '<div class="form-group space-comment"><label>'.esc_attr__( 'Review', 'boxcar' ).'</label><textarea id="comment" placeholder="'.esc_attr__( 'Your Review...', 'boxcar' ).'" class="form-control" name="comment" cols="45" rows="5" aria-required="true" required></textarea></div>';
				
				boxcar_comment_form($comment_form);
			?>
		</div>
	</div>
</div>