<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
// global $post;

$related_columns = boxcar_get_config('listing_related_columns', 4);

$relate_count = apply_filters('wp_cardealer_number_listing_related', boxcar_get_config('listing_related_number', 4));

$tax_query = array();
$terms = get_the_terms( $post->ID, 'listing_type' );
$similar_url = WP_CarDealer_Mixes::get_listings_page_url();
if ($terms) {
    $termids = array();
    foreach($terms as $term) {
        $termids[] = $term->term_id;
        $similar_url = add_query_arg( 'filter-type', $term->slug, $similar_url );
    }
    $tax_query[] = array(
        'taxonomy' => 'listing_type',
        'field' => 'id',
        'terms' => $termids,
        'operator' => 'IN'
    );
}

if ( empty($tax_query) ) {
    return;
}
$args = array(
    'post_type' => 'listing',
    'posts_per_page' => $relate_count,
    'post__not_in' => array( $post->ID ),
    'tax_query' => array_merge(array( 'relation' => 'AND' ), $tax_query)
);
$relates = WP_CarDealer_Query::get_posts( $args, true );

if( $relates->have_posts() ):
?>
    <div class="wrapper-listings-related">
        <div class="container">
            <div class="related-listings">
                <div class="flex-middle-sm top-related">
                    <h4 class="title">
                        <?php esc_html_e( 'Similar Cars', 'boxcar' ); ?>
                    </h4>
                    <div class="ali-right">
                        <a href="<?php echo esc_url($similar_url); ?>" class="btn-readmore flex-middle"><?php esc_html_e( 'Show All Cars', 'boxcar' ); ?> <span class="plus">
                        <svg width="11" height="11" viewBox="0 0 11 11" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
                        <path d="M5 0H6V11H5V0Z"></path>
                        <path d="M4.37113e-08 6L0 5L11 5V6L4.37113e-08 6Z"></path>
                        </svg>
                    </span></a>
                    </div>
                </div>
                <div class="widget-content">
                    <div class="slick-carousel" data-carousel="slick" data-smallmedium="2" data-extrasmall="1" data-items="<?php echo esc_attr($related_columns); ?>" data-pagination="false" data-nav="true">
                        <?php while ( $relates->have_posts() ) : $relates->the_post(); ?>
                            <div class="item">
                                <?php echo WP_CarDealer_Template_Loader::get_template_part( 'listings-styles/inner-grid' ); ?>
                            </div>
                        <?php endwhile; ?>
                    </div>
                    <?php wp_reset_postdata(); ?>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>