<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
global $post;

$meta_obj = WP_CarDealer_Listing_Meta::get_instance($post->ID);

$gallery = $meta_obj->get_post_meta( 'gallery' );
if ( has_post_thumbnail() || $gallery ) {
    $imagesize = !empty($imagesize) ? $imagesize : '812x550';
    $thumbnailsize = !empty($thumbnailsize) ? $thumbnailsize : '284x270';
    $first_class = 'col-12';
    $second_class = 'col-6';
    if ( $gallery ) {
        $first_class = 'col-md-7 col-12';
        if ( count($gallery) == 1 ) {
            $second_class = 'col-12';
            $thumbnailsize = '521x550';
        }
    } else {
        $imagesize = '1400x550';
    }
?>
<div class="listing-detail-gallery <?php echo esc_attr($layout_type); ?>">
    <div class="row row-10">
        <?php if ( has_post_thumbnail() ) {
            $thumbnail_id = get_post_thumbnail_id($post);
        ?>
            <div class="<?php echo esc_attr($first_class); ?>">
                <div class="listing-single-gallery-wrapper">
                        <a href="<?php echo esc_url( get_the_post_thumbnail_url($post, 'full') ); ?>" data-elementor-lightbox-slideshow="boxcar-gallery" class="p-popup-image">
                            <?php echo boxcar_get_attachment_thumbnail($thumbnail_id, $imagesize);?>
                        </a>

                    <div class="top-label">
                        <?php boxcar_listing_display_featured_icon($post, true); ?>
                        <?php boxcar_listing_display_label_label($post); ?>
                    </div>
                    <?php boxcar_listing_video_btn($post); ?>
                    
                </div>
            </div>
        <?php } ?>

        <?php if ( $gallery ) { ?>
            <div class="col-md-5 col-12">
                <div class="row row-10 right-images">
                    <?php $i=1; foreach ( $gallery as $id => $src ) {
                        
                        $additional_class = '';
                        if ( $i > 4 ) {
                            $additional_class = 'hidden';
                        }

                        $more_image_class = $more_image_html = '';
                        if ( $i == 4 && count($gallery) > 4 ) {
                            $more_image_html = '<div class="view-more-gallery"><i class="flaticon-camera"></i> <span class="text">'.esc_html__('All Photos', 'boxcar').'</span></div>';
                            $more_image_class = 'view-more-image';
                        }
                    ?>
                        <div class="<?php echo esc_attr($second_class.' '.$additional_class); ?>">
                                <a href="<?php echo esc_url( $src ); ?>" data-elementor-lightbox-slideshow="boxcar-gallery" class="<?php echo esc_attr( ($i>=3)?'m-0':'' ); ?> p-popup-image <?php echo esc_attr($more_image_class); ?>">
                                    <?php
                                    if ( $i <= 4 ) {
                                        echo boxcar_get_attachment_thumbnail( $id, $thumbnailsize );
                                        echo trim($more_image_html);
                                    }
                                    ?>
                                </a>
                        </div>
                    <?php $i++; } ?>
                </div>
            </div>
        <?php } ?>
    </div>
</div>
<?php }