<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
global $post;

$meta_obj = WP_CarDealer_Listing_Meta::get_instance($post->ID);

$gallery = $meta_obj->get_post_meta( 'gallery' );
if ( has_post_thumbnail() || $gallery ) {
    $imagesize = !empty($imagesize) ? $imagesize : 'medium';
?>
<div class="listing-detail-gallery <?php echo esc_attr($layout_type); ?>">
    
    <div class="listing-single-gallery-wrapper">
        <div class="top-label">
            <?php boxcar_listing_display_featured_icon($post, true); ?>
            <?php boxcar_listing_display_label_label($post); ?>
        </div>
        <?php boxcar_listing_video_btn($post); ?>
        
        <div class="slick-carousel no-gap" data-carousel="slick" 
            data-items="1"
            data-large="1"
            data-medium="1"
            data-small="1"
            data-smallest="1"
            data-slidestoscroll="1"
            data-slidestoscroll_large="1"
            data-slidestoscroll_medium="1"
            data-slidestoscroll_small="1"
            data-slidestoscroll_smallest="1"
            data-pagination="false" data-nav="true" data-slickparent="true" data-infinite="true">
            <?php if ( has_post_thumbnail() ) {
                $thumbnail_id = get_post_thumbnail_id($post);
            ?>
                <a href="<?php echo esc_url( get_the_post_thumbnail_url($post, 'full') ); ?>" data-elementor-lightbox-slideshow="boxcar-gallery" class="p-popup-image mb-0">
                    <?php echo boxcar_get_attachment_thumbnail($thumbnail_id, $imagesize);?>
                </a>
            <?php } ?>

            <?php if ( $gallery ) {
                foreach ( $gallery as $id => $src ) {
                ?>
                    <a href="<?php echo esc_url( $src ); ?>" data-elementor-lightbox-slideshow="boxcar-gallery" class="p-popup-image mb-0">
                        <?php echo boxcar_get_attachment_thumbnail( $id, $imagesize ); ?>
                    </a>
                <?php }
            } ?>
        </div>
    </div>

</div>
<?php }