<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
global $post;

$features = get_the_terms($post->ID, 'listing_feature');

?>

<?php if ( ! empty( $features ) ) :
    $features_cats = [];
    foreach ($features as $feature) {
        $parent = get_term_meta( $feature->term_id, '_category_parent', true );
        if ( !empty($parent) ) {
            if ( !is_array($parent) ) {
                $features_cats[$parent]['features'][] = $feature;

                $menu_order = 0;
                $term = get_term_by('slug', $parent, 'listing_feature_category');
                if ( $term ) {
                    $menu_order = get_term_meta( $term->term_id, 'menu_order', true );
                    $features_cats[$parent]['priority'] = $menu_order;
                    $features_cats[$parent]['parent_term'] = $term;
                }
            } else {
                foreach ($parent as $parent_id) {
                    $features_cats[$parent_id]['features'][] = $feature;
                    $menu_order = 0;
                    $term = get_term_by('slug', $parent_id, 'listing_feature_category');
                    if ( $term ) {
                        $menu_order = get_term_meta( $term->term_id, 'menu_order', true );
                        $features_cats[$parent_id]['priority'] = $menu_order;
                        $features_cats[$parent]['parent_term'] = $term;
                    }
                }
            }
        } else {
            $features_cats[0]['features'][] = $feature;
            $features_cats[$parent]['priority'] = 0;
        }
    }

    if ( $features_cats ) {
        uasort( $features_cats, array( 'WP_CarDealer_Mixes', 'sort_array_by_priority' ) );
    }
?>
    
    <div class="description-inner">
        <div class="description-inner-wrapper d-sm-flex flex-wrap">
            <?php foreach ( $features_cats as $parent_slug => $features ) :
                if ( !empty($features['features']) ) {
            ?>
                    <div class="feature-cat col-sm-6 col-xl-3">
                        <div class="title-wrapper">
                            <?php if ( !empty($features['parent_term']) ) {
                                echo esc_html($features['parent_term']->name);
                            } else {
                                esc_html_e('General', 'boxcar');
                            } ?>
                        </div>
                        <div class="inner-right">
                            <ul class="list-style">
                                <?php foreach ( $features['features'] as $feature ) : ?>
                                    <li>
                                        <?php echo esc_html( $feature->name ); ?>  
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                <?php } ?>
            <?php endforeach; ?>
            
        </div>

        <?php do_action('wp-cardealer-single-listing-features', $post); ?>
    </div>
        
<?php endif; ?>