<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
global $post;

$meta_obj = WP_CarDealer_Listing_Meta::get_instance($post->ID);
$listing_version = (!empty($listing_version)) ? $listing_version: '';
$print_car = isset($print_car) ? $print_car : false;
$show_url = $print_car ? false : true;
?>
<div id="listing-detail-detail" class="listing-detail-detail">
    <h3 class="title"><?php esc_html_e('Details', 'boxcar'); ?></h3>
    <ul class="list">

        <?php boxcar_listing_display_tax_list($post, 'type', $show_url); ?>
        <?php boxcar_listing_display_tax_list($post, 'make', $show_url); ?>
        <?php boxcar_listing_display_tax_list($post, 'model', $show_url); ?>
        <?php boxcar_listing_display_tax_list($post, 'color', $show_url); ?>
        <?php boxcar_listing_display_tax_list($post, 'drive_type', $show_url); ?>
        <?php boxcar_listing_display_tax_list($post, 'transmission', $show_url); ?>
        <?php boxcar_listing_display_tax_list($post, 'condition', $show_url); ?>
        
        <?php if($listing_version != 'v3') { ?>
            <!-- year and mileage -->
            <?php if ( $meta_obj->check_post_meta_exist('year') && ($year = $meta_obj->get_post_meta('year')) ) { ?>
                <li>
                    <div class="text"><?php echo esc_html($meta_obj->get_post_meta_title( 'year' )); ?>:</div>
                    <div class="value"><?php echo trim($year); ?></div>
                </li>
            <?php } ?>
            <?php if ( $meta_obj->check_post_meta_exist('mileage') && ($mileage = $meta_obj->get_post_meta('mileage')) ) { ?>
                <li>
                    <div class="text"><?php echo esc_html($meta_obj->get_post_meta_title( 'mileage' )); ?>:</div>
                    <div class="value"><?php echo trim($mileage); ?></div>
                </li>
            <?php } ?>
        <?php } ?>

        <?php boxcar_listing_display_tax_list($post, 'fuel_type', $show_url); ?>
        
        <!-- Engine size -->
        <?php if ( $meta_obj->check_post_meta_exist('engine_size') && ($engine_size = $meta_obj->get_post_meta('engine_size')) ) { ?>
            <li>
                <div class="text"><?php echo esc_html($meta_obj->get_post_meta_title( 'engine_size' )); ?>:</div>
                <div class="value"><?php echo trim($engine_size); ?></div>
            </li>
        <?php } ?>

        <?php boxcar_listing_display_tax_list($post, 'door', $show_url); ?>
        <?php boxcar_listing_display_tax_list($post, 'cylinder', $show_url); ?>
        <!-- Vin -->
        <?php if ( $meta_obj->check_post_meta_exist('vin') && ($vin = $meta_obj->get_post_meta('vin')) ) { ?>
            <li>
                <div class="text"><?php echo esc_html($meta_obj->get_post_meta_title( 'vin' )); ?>:</div>
                <div class="value"><?php echo trim($vin); ?></div>
            </li>
        <?php } ?>
        

        <?php do_action('wp-cardealer-single-listing-details', $post); ?>
    </ul>
</div>