<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

get_header();

?>

<section id="primary" class="content-area inner">
	<div id="main" class="site-main content" role="main">
		<?php if ( have_posts() ) : ?>

			<?php while ( have_posts() ) : the_post();
				global $post;
				$latitude = WP_CarDealer_Dealer::get_post_meta( $post->ID, 'map_location_latitude', true );
				$longitude = WP_CarDealer_Dealer::get_post_meta( $post->ID, 'map_location_longitude', true );
			?>
				<div class="single-listing-wrapper" data-latitude="<?php echo esc_attr($latitude); ?>" data-longitude="<?php echo esc_attr($longitude); ?>">
					<?php the_content(); ?>
				</div>
			<?php endwhile; ?>

			<?php the_posts_pagination( array(
				'prev_text'          => esc_html__( 'Previous page', 'boxcar' ),
				'next_text'          => esc_html__( 'Next page', 'boxcar' ),
				'before_page_number' => '<span class="meta-nav screen-reader-text">' . esc_html__( 'Page', 'boxcar' ) . ' </span>',
			) ); ?>
		<?php else : ?>
			<div class="container">
				<?php get_template_part( 'content', 'none' ); ?>
			</div>
		<?php endif; ?>
	</div><!-- .site-main -->
</section><!-- .content-area -->
<?php get_footer(); ?>