<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$register_title = !empty($register_title) ? $register_title : '';

wp_enqueue_style( 'dashicons' );
?>
<div class="register-form-wrapper">
  	<div class="form-login-register-inner">
	  		<div class="left-inner">
		      	<form name="registerForm" method="post" class="register-form form-theme">
					<div class="form-group">
						<label><?php echo esc_html__('User Name','boxcar'); ?></label>
						<input type="text" class="form-control" name="username" id="register-username" placeholder="<?php echo esc_html__('ali...','boxcar'); ?>">
					</div>
					<div class="form-group">
						<label ><?php echo esc_html__('Email','boxcar'); ?></label>
						<input type="text" class="form-control" name="email" id="register-email" placeholder="<?php echo esc_html__('crea...','boxcar'); ?>">
					</div>

					<?php if ( wp_cardealer_get_option('users_requires_approval') == 'phone_approve' ) { ?>
						<div class="form-group d-flex align-items-center">
							<?php
							
								$cc_list = include WP_CARDEALER_PLUGIN_DIR.'includes/sms/countries-phone.php';
								if ( wp_cardealer_get_option('phone_approve_default_country_code') == 'geolocation' ) {
									$default_cc = WP_CarDealer_SMS_Geolocation::get_phone_code();
								} else {
									$default_cc = wp_cardealer_get_option('phone_approve_default_country_code_custom');
								}
							?>
								<select class="form-control" name="phone-cc" id="register-phone-cc" required>
									<option disabled><?php esc_html_e( 'Select Country Code', 'boxcar' ); ?></option>
									<?php foreach( $cc_list as $country_code => $country_phone_code ): ?>
										<option value="<?php echo esc_attr($country_phone_code); ?>" <?php selected($country_phone_code, $default_cc); ?>><?php echo esc_html($country_code.' '.$country_phone_code); ?></option>
									<?php endforeach; ?>
								</select>
								

							<input type="text" class="form-control" name="phone" id="register-phone" placeholder="<?php esc_attr_e('Phone','boxcar'); ?>" required>

						</div>

						<input type="hidden" class="form-control" name="step" id="register-step" value="1">
						<input type="hidden" class="form-control" name="form-token" id="register-form-token" value="<?php echo mt_rand( 1000, 9999 ); ?>">
					<?php } ?>

					<div class="form-group">
						<label><?php echo esc_html__('Password','boxcar'); ?></label>
						<span class="show_hide_password">
							<input type="password" class="form-control" name="password" id="password" placeholder="enter...">
							<a class="toggle-password" title="<?php esc_attr_e('Show', 'boxcar'); ?>"><span class="dashicons dashicons-hidden"></span></a>
						</span>
					</div>

					<div class="form-group">
						<label><?php echo esc_html__('Re-enter Password','boxcar'); ?></label>
						<span class="show_hide_password">
							<input type="password" class="form-control" name="confirmpassword" id="confirmpassword" placeholder="enter...">
							<a class="toggle-password" title="<?php esc_attr_e('Show', 'boxcar'); ?>"><span class="dashicons dashicons-hidden"></span></a>
						</span>
					</div>

					<?php wp_nonce_field('ajax-register-nonce', 'security_register'); ?>

					<?php if ( WP_CarDealer_Recaptcha::is_recaptcha_enabled() ) { ?>
			            <div id="recaptcha-contact-form" class="ga-recaptcha" data-sitekey="<?php echo esc_attr(wp_cardealer_get_option( 'recaptcha_site_key' )); ?>"></div>
			      	<?php } ?>

			      	<?php
			      		$page_id = wp_cardealer_get_option('terms_conditions_page_id');
			      		if ( !empty($page_id) ) {
			      			$page_id = WP_CarDealer_Mixes::get_lang_post_id($page_id);
			      			$page_url = get_permalink($page_id);
			      			?>
				      	<div class="form-group">
							<label for="register-terms-and-conditions">
								<input type="checkbox" name="terms_and_conditions" value="on" id="register-terms-and-conditions" required>
								<?php
									echo sprintf(wp_kses(__('I have read and accept the <a href="%s">Terms and Privacy Policy</a>', 'boxcar'), array('a' => array('href' => array())) ), esc_url($page_url));
								?>
							</label>
						</div>
					<?php } ?>

					<div class="form-group no-margin">
						<button type="submit" class="btn btn-theme w-100" name="submitRegister">
							<?php echo esc_html__('REGISTER', 'boxcar'); ?><svg xmlns="http://www.w3.org/2000/svg" class="next" width="14" height="14" viewBox="0 0 14 14" fill="none">
            <path d="M13.6109 0H5.05533C4.84037 0 4.66643 0.173943 4.66643 0.388901C4.66643 0.603859 4.84037 0.777802 5.05533 0.777802H12.6721L0.113697 13.3362C-0.0382246 13.4881 -0.0382246 13.7342 0.113697 13.8861C0.18964 13.962 0.289171 14 0.388666 14C0.488161 14 0.587656 13.962 0.663635 13.8861L13.222 1.3277V8.94447C13.222 9.15943 13.3959 9.33337 13.6109 9.33337C13.8259 9.33337 13.9998 9.15943 13.9998 8.94447V0.388901C13.9998 0.173943 13.8258 0 13.6109 0Z" fill="currentColor"/>
            </svg>
						</button>
					</div>
		      	</form>

		      	<?php if ( wp_cardealer_get_option('users_requires_approval') == 'phone_approve' ) { ?>
			  		<form name="registerFormOTP" method="post" class="register-form-otp form-login-register-inner">

						<div class="sent-txt">
							<span class="no-txt"></span>
							<span class="no-change"> <?php esc_html_e( 'Change', 'boxcar' ); ?></span>
						</div>

						<div class="notice-cont">
							<div class="notice"></div>
						</div>

						<div class="form-group mb-3">
							<div class="otp-input-cont">
								<?php for ( $i= 0; $i < wp_cardealer_get_option('phone_approve_otp_digits', 4); $i++ ): ?>
									<input type="text" maxlength="1" autocomplete="off" name="otp[]" class="otp-input">
								<?php endfor; ?>
							</div>
						</div>

						<button type="submit" class="btn btn-second w-100"><?php esc_html_e( 'Verify', 'boxcar' ); ?></button>

						<div class="resend">
							<a href="javascript:void(0);" class="resend-link"><?php esc_html_e( 'Not received your code? Resend code', 'boxcar' ); ?></a>
							<span class="resend-timer"></span>
						</div>

					</form>
				<?php } ?>

				<?php do_action('register_form'); ?>
			</div>
			<?php do_action('login_form'); ?>
    </div>
</div>