<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
wp_enqueue_style( 'dashicons' );
?>
<div class="profile-form-wrapper">
	<h1 class="title-profile"><?php esc_html_e( 'Edit Profile', 'boxcar' ) ; ?></h1>
	<?php if ( ! empty( $_SESSION['messages'] ) ) : ?>

		<?php foreach ( $_SESSION['messages'] as $message ) { ?>
			<?php
			$status = !empty( $message[0] ) ? $message[0] : 'success';
			if ( !empty( $message[1] ) ) {
			?>
			<div class="alert alert-<?php echo esc_attr( $status ) ?> margin-bottom-15">
				<?php echo esc_html( $message[1] ); ?>
			</div>
		<?php
			}
		}
		unset( $_SESSION['messages'] );
		?>

	<?php endif; ?>

	<?php
		$user_id = get_current_user_id();
		echo cmb2_get_metabox_form( $metaboxes_form, $user_id, array(
			'form_format' => '<form action="" class="cmb-form" method="post" id="%1$s" enctype="multipart/form-data" encoding="multipart/form-data"><input type="hidden" name="object_id" value="%2$s">%3$s<input type="submit" name="submit-cmb-profile" value="%4$s" class="button-primary btn btn-theme"></form>',
			'save_button' => esc_html__( 'Save Profile', 'boxcar' ),
		) );
	?>
</div>