<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

wp_enqueue_style( 'dashicons' );
?>
<h1 class="title-profile"><?php esc_html_e('Change Password', 'boxcar'); ?></h1>
<div class="box-white-dashboard max-600">
	<form method="post" action="" class="change-password-form form-theme">
		<div class="clearfix">
			<div class="row">
				<div class="col-12">
					<div class="form-group">
						<label><?php echo esc_html__( 'Old password', 'boxcar' ); ?></label>
						<span class="show_hide_password">
							<input id="change-password-form-old-password" class="form-control" placeholder="<?php esc_attr_e( 'password...', 'boxcar' ); ?>" type="password" name="old_password" required="required">
							<a class="toggle-password" title="<?php esc_attr_e('Show', 'boxcar'); ?>"><span class="dashicons dashicons-hidden"></span></a>
						</span>
					</div><!-- /.form-control -->
				</div>
				<div class="col-12">
					<div class="form-group">
						<label><?php echo esc_html__( 'New password', 'boxcar' ); ?></label>
						<span class="show_hide_password">
							<input id="change-password-form-new-password" class="form-control" placeholder="<?php esc_attr_e( 'password...', 'boxcar' ); ?>" type="password" name="new_password" required="required" minlength="8">
							<a class="toggle-password" title="<?php esc_attr_e('Show', 'boxcar'); ?>"><span class="dashicons dashicons-hidden"></span></a>
						</span>
					</div><!-- /.form-control -->
				</div>
				<div class="col-12">
					<div class="form-group">
						<label><?php echo esc_html__( 'Retype Password', 'boxcar' ); ?></label>
						<span class="show_hide_password">
							<input id="change-password-form-retype-password" class="form-control" placeholder="<?php esc_attr_e( 'password...', 'boxcar' ); ?>" type="password" name="retype_password" required="required" minlength="8">
							<a class="toggle-password" title="<?php esc_attr_e('Show', 'boxcar'); ?>"><span class="dashicons dashicons-hidden"></span></a>
						</span>
					</div><!-- /.form-control -->
				</div>
			</div>
		</div>
		<button type="submit" name="change_password_form" class="button btn btn-theme"><?php echo esc_html__( 'Change Password', 'boxcar' ); ?><svg xmlns="http://www.w3.org/2000/svg" class="next" width="14" height="14" viewBox="0 0 14 14" fill="none">
            <path d="M13.6109 0H5.05533C4.84037 0 4.66643 0.173943 4.66643 0.388901C4.66643 0.603859 4.84037 0.777802 5.05533 0.777802H12.6721L0.113697 13.3362C-0.0382246 13.4881 -0.0382246 13.7342 0.113697 13.8861C0.18964 13.962 0.289171 14 0.388666 14C0.488161 14 0.587656 13.962 0.663635 13.8861L13.222 1.3277V8.94447C13.222 9.15943 13.3959 9.33337 13.6109 9.33337C13.8259 9.33337 13.9998 9.15943 13.9998 8.94447V0.388901C13.9998 0.173943 13.8258 0 13.6109 0Z" fill="currentColor"/>
            </svg></button>
	</form>
</div>