<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
boxcar_load_select2();
$rand = boxcar_random_key();

$login_title = !empty($login_title) ? $login_title : '';
$reset_password_title = !empty($reset_password_title) ? $reset_password_title : '';

wp_enqueue_style( 'dashicons' );
?>
<div class="login-form-wrapper">
	
	<div id="login-form-wrapper-<?php echo esc_attr($rand); ?>" class="form-container form-login-register-inner">
		<form class="login-form form-theme" action="<?php echo esc_url( home_url( '/' ) ); ?>" method="post">
				<div class="left-inner">
					<div class="form-group">
						<label for="username_or_email"><?php esc_html_e('Username Or Email', 'boxcar'); ?></label>
						<input autocomplete="off" type="text" name="username" class="form-control" id="username_or_email" placeholder="<?php echo esc_html__('ali...','boxcar'); ?>">
					</div>
					<div class="form-group">
						<label for="login_password"><?php echo esc_html__('Password','boxcar'); ?></label>
						<span class="show_hide_password">
							<input name="password" type="password" class="password required form-control" id="login_password" placeholder="<?php echo esc_html__('***','boxcar'); ?>">
							<a class="toggle-password" title="<?php esc_attr_e('Show', 'boxcar'); ?>"><span class="dashicons dashicons-hidden"></span></a>
						</span>
					</div>
					<div class="row item-group">
						<div class="col-md-6">
							<label for="user-remember-field" class="mb-0">
								<input type="checkbox" name="remember" id="user-remember-field" value="true"> <?php echo esc_html__('Keep me signed in','boxcar'); ?>
							</label>
						</div>
						<div class="col-md-6 text-end">
							<a href="#forgot-password-form-wrapper-<?php echo esc_attr($rand); ?>" class="back-link" title="<?php esc_attr_e('Forgot Password','boxcar'); ?>"><?php echo esc_html__("Lost Your Password?",'boxcar'); ?></a>
						</div>
					</div>
					<div class="form-group space-30">
						<button class="btn btn btn-theme w-100" type="submit" name="submit"><?php esc_attr_e('Login','boxcar'); ?><svg xmlns="http://www.w3.org/2000/svg" class="next" width="14" height="14" viewBox="0 0 14 14" fill="none">
            <path d="M13.6109 0H5.05533C4.84037 0 4.66643 0.173943 4.66643 0.388901C4.66643 0.603859 4.84037 0.777802 5.05533 0.777802H12.6721L0.113697 13.3362C-0.0382246 13.4881 -0.0382246 13.7342 0.113697 13.8861C0.18964 13.962 0.289171 14 0.388666 14C0.488161 14 0.587656 13.962 0.663635 13.8861L13.222 1.3277V8.94447C13.222 9.15943 13.3959 9.33337 13.6109 9.33337C13.8259 9.33337 13.9998 9.15943 13.9998 8.94447V0.388901C13.9998 0.173943 13.8258 0 13.6109 0Z" fill="currentColor"/>
            </svg></button>
					</div>
					<?php
						wp_nonce_field('ajax-login-nonce', 'security_login');
					?>
				</div>
				<?php do_action('login_form'); ?>
		</form>

		<?php if ( defined('BOXCAR_DEMO_MODE') && BOXCAR_DEMO_MODE ) { ?>
			<div class="sign-in-demo-notice">
				Username: <strong>demo</strong><br>
				Password: <strong>demo</strong>
			</div>
		<?php } ?>

	</div>
	<!-- reset form -->
	<div id="forgot-password-form-wrapper-<?php echo esc_attr($rand); ?>" class="form-container form-login-register-inner form-forgot-password-inner">
		<?php if ( $reset_password_title ) { ?>
			<h2 class="title"><?php echo esc_html($reset_password_title); ?></h2>
		<?php } ?>
		<form name="forgotpasswordform" class="forgotpassword-form form-theme" action="<?php echo esc_url( site_url('wp-login.php?action=lostpassword', 'login_post') ); ?>" method="post">
			<div class="lostpassword-fields">
				<div class="form-group">
					<input type="text" name="user_login" class="user_login form-control" id="lostpassword_username">
					<label for="lostpassword_username" class="for-control"><?php echo esc_html__('Username or E-mail','boxcar'); ?></label>
				</div>
				<?php
					do_action('lostpassword_form');
					wp_nonce_field('ajax-lostpassword-nonce', 'security_lostpassword');
				?>

				<?php if ( WP_CarDealer_Recaptcha::is_recaptcha_enabled() ) { ?>
		            <div id="recaptcha-contact-form" class="ga-recaptcha" data-sitekey="<?php echo esc_attr(wp_cardealer_get_option( 'recaptcha_site_key' )); ?>"></div>
		      	<?php } ?>

				<div class="form-group">
					<button class="btn btn-theme w-100" type="submit" name="wp-submit"><?php esc_attr_e('Get New Password', 'boxcar'); ?><svg xmlns="http://www.w3.org/2000/svg" class="next" width="14" height="14" viewBox="0 0 14 14" fill="none">
            <path d="M13.6109 0H5.05533C4.84037 0 4.66643 0.173943 4.66643 0.388901C4.66643 0.603859 4.84037 0.777802 5.05533 0.777802H12.6721L0.113697 13.3362C-0.0382246 13.4881 -0.0382246 13.7342 0.113697 13.8861C0.18964 13.962 0.289171 14 0.388666 14C0.488161 14 0.587656 13.962 0.663635 13.8861L13.222 1.3277V8.94447C13.222 9.15943 13.3959 9.33337 13.6109 9.33337C13.8259 9.33337 13.9998 9.15943 13.9998 8.94447V0.388901C13.9998 0.173943 13.8258 0 13.6109 0Z" fill="currentColor"/>
            </svg></button>
				</div>
			</div>
			<div class="lostpassword-link"><a href="#login-form-wrapper-<?php echo esc_attr($rand); ?>" class="back-link"><?php echo esc_html__('Back To Login', 'boxcar'); ?></a></div>
		</form>
	</div>
</div>