<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
if ( empty($listings) ) {
	return;
}
$pagination_type = !empty($settings['pagination_type']) ? $settings['pagination_type'] : 'default';
?>

<div class="listings-pagination-wrapper main-pagination-wrapper" data-settings="<?php echo esc_attr(json_encode($settings)); ?>">
	<?php
		if ( $pagination_type == 'loadmore' || $pagination_type == 'infinite' ) {
			$next_link = get_next_posts_link( '&nbsp;', $listings->max_num_pages );
			if ( $next_link ) {
		?>
				<div class="ajax-pagination <?php echo esc_attr($pagination_type == 'loadmore' ? 'loadmore-action' : 'infinite-action'); ?>">
					<div class="apus-pagination-next-link hidden"><?php echo trim($next_link); ?></div>
					<a href="#" class="apus-loadmore-btn"><?php esc_html_e( 'Load more', 'boxcar' ); ?></a>
					<span class="apus-allproducts"><?php esc_html_e( 'All listings loaded.', 'boxcar' ); ?></span>
				</div>
		<?php
			}
		} else {
			WP_CarDealer_Mixes::custom_pagination( array(
				'max_num_pages' => $listings->max_num_pages,
				'prev_text'     => '<i class="flaticon-arrowhead-thin-outline-to-the-left"></i>',
				'next_text'     => '<i class="flaticon-arrow-point-to-right"></i>',
				'wp_query' => $listings
			));
		}
	?>
</div>
