<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
global $post;
?>
<?php do_action( 'wp_cardealer_before_listing_content', $post->ID ); ?>
<article <?php post_class('map-item listing-list listing-item'); ?> <?php boxcar_listing_item_map_meta($post); ?> <?php boxcar_listing_display_gallery($post, 'boxcar-listing-list'); ?>>
    <div class="d-md-flex">
        <div class="left-inner flex-shrink-0">
            <div class="listing-thumbnail-wrapper position-relative">
                <?php boxcar_listing_display_image( $post, 'boxcar-listing-list' ); ?>
                <div class="top-label d-flex align-items-center w-100">
                    <?php boxcar_listing_display_featured_icon($post, true); ?>
                    <?php boxcar_listing_display_label_label($post); ?>
                </div>
            </div>
        </div>

        <div class="right-inner flex-grow-1 d-flex">
            <div class="d-md-flex flex-grow-1">
                <div class="listing-information d-flex flex-column flex-grow-1 justify-content-center">

                    <?php $tagline = boxcar_listing_display_meta($post, 'tagline', '', false); ?>
                    <?php the_title( sprintf( '<h2 class="listing-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
                    <?php echo trim($tagline); ?>
                    
                    <?php
                    $meta_obj = WP_CarDealer_Listing_Meta::get_instance($post->ID);

                    $unit = wp_cardealer_get_option('search_distance_unit', 'miles');
                    if ( $unit == 'miles' ) {
                        $unit = esc_html__('Miles', 'boxcar');
                    } elseif( $unit == 'km' ) {
                        $unit = esc_html__('Km', 'boxcar');
                    }
                    $mileage = boxcar_listing_display_meta($post, 'mileage', 'flaticon-speedometer', true, $unit);
                    $fuel_type = boxcar_listing_display_tax_without_url($post, 'fuel_type', 'flaticon-gasoline-pump', true, false );
                    $transmission = boxcar_listing_display_tax_without_url($post, 'transmission', 'flaticon-gearbox', true, false );

                    if ( $mileage || $transmission || $fuel_type ) {
                    ?>
                        <div class="listing-metas d-flex flex-wrap">
                            <?php
                                echo trim($mileage);
                                echo trim($fuel_type);
                                echo trim($transmission);
                            ?>
                        </div>
                    <?php } ?>

                    <?php 
                        $type = boxcar_listing_display_tax_without_url($post, 'type', '', false, false );
                        $make = boxcar_listing_display_tax_without_url($post, 'make', '', false, false );
                        $model = boxcar_listing_display_tax_without_url($post, 'model', '', false, false );
                        if ( $type || $make || $model ) {
                    ?>
                        <div class="metas-radius d-none d-lg-flex flex-wrap">
                            <?php
                                echo trim($type);
                                echo trim($make);
                                echo trim($model);
                            ?>
                        </div>
                    <?php } ?>
                </div>
                <div class="action-right d-flex flex-md-column align-items-md-end flex-shrink-0 justify-content-md-center">
                    <?php 
                    if ( boxcar_get_config('listing_enable_favorite', true) ) {
                        $args = array(
                            'show_text' => true,
                            'added_icon_class' => 'flaticon-bookmark',
                            'add_icon_class' => 'flaticon-bookmark',
                            'added_text' => esc_html__('Save', 'boxcar'),
                            'add_text' => esc_html__('Save', 'boxcar'),
                        );
                        WP_CarDealer_Favorite::display_favorite_btn($post->ID, $args);
                    }
                    ?>
                    <?php boxcar_listing_display_price($post); ?>
                    <a href="<?php the_permalink(); ?>" class="btn btn-theme btn-outline d-none d-md-inline-block"><?php echo esc_html__( 'View Details', 'boxcar' )?><svg xmlns="http://www.w3.org/2000/svg" class="next" width="14" height="14" viewBox="0 0 14 14" fill="none">
                    <path d="M13.6109 0H5.05533C4.84037 0 4.66643 0.173943 4.66643 0.388901C4.66643 0.603859 4.84037 0.777802 5.05533 0.777802H12.6721L0.113697 13.3362C-0.0382246 13.4881 -0.0382246 13.7342 0.113697 13.8861C0.18964 13.962 0.289171 14 0.388666 14C0.488161 14 0.587656 13.962 0.663635 13.8861L13.222 1.3277V8.94447C13.222 9.15943 13.3959 9.33337 13.6109 9.33337C13.8259 9.33337 13.9998 9.15943 13.9998 8.94447V0.388901C13.9998 0.173943 13.8258 0 13.6109 0Z" fill="currentColor"/>
                    </svg></a>
                </div>
            </div>
        </div>
    </div>
</article><!-- #post-## -->

<?php do_action( 'wp_cardealer_after_listing_content', $post->ID ); ?>