<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
global $post;
?>
<div class="col-12 col-xl-3 col-md-6 listing-favorite-wrapper">
    <?php do_action( 'wp_cardealer_before_listing_content', $post->ID ); ?>
    <article <?php post_class('map-item listing-grid listing-item'); ?> <?php boxcar_listing_item_map_meta($post); ?> <?php boxcar_listing_display_gallery($post, 'boxcar-listing-grid'); ?>>

        <div class="listing-thumbnail-wrapper position-relative">
            <?php boxcar_listing_display_image( $post, 'boxcar-listing-grid' ); ?>
            
            <div class="top-label d-flex align-items-center w-100">
                <div class="inner">
                    <?php boxcar_listing_display_label_label($post); ?>
                </div>
                <div class="ms-auto">
                    <a href="javascript:void(0)" data-toggle="tooltip" title="<?php esc_attr_e('Remove', 'boxcar'); ?>" class="btn-remove-listing-favorite btn-action-icon" data-listing_id="<?php echo esc_attr($post->ID); ?>" data-nonce="<?php echo esc_attr(wp_create_nonce( 'wp-cardealer-remove-listing-favorite-nonce' )); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M7.06907 7.69027C7.37819 7.65937 7.65382 7.8849 7.68472 8.19405L8.05972 11.944C8.0907 12.2531 7.8651 12.5288 7.55602 12.5597C7.2469 12.5906 6.97124 12.3651 6.94033 12.0559L6.56533 8.30595C6.53442 7.99687 6.75995 7.72117 7.06907 7.69027Z" fill="currentColor"></path>
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M10.931 7.69027C11.2401 7.72117 11.4656 7.99687 11.4347 8.30595L11.0597 12.0559C11.0288 12.3651 10.7532 12.5906 10.444 12.5597C10.135 12.5288 9.90943 12.2531 9.94033 11.944L10.3153 8.19405C10.3462 7.8849 10.6219 7.65937 10.931 7.69027Z" fill="currentColor"></path>
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M7.59285 0.937514H10.129C10.2913 0.937409 10.4327 0.937319 10.5662 0.958642C11.0936 1.04287 11.5501 1.37186 11.7968 1.84563C11.8592 1.96555 11.9039 2.09971 11.9551 2.2537L12.0388 2.50488C12.053 2.5474 12.057 2.55943 12.0605 2.56891C12.1918 2.932 12.5323 3.17744 12.9183 3.18723C12.9284 3.18748 12.9409 3.18753 12.9859 3.18753H15.2359C15.5466 3.18753 15.7984 3.43936 15.7984 3.75003C15.7984 4.06069 15.5466 4.31253 15.2359 4.31253H2.48584C2.17518 4.31253 1.92334 4.06069 1.92334 3.75003C1.92334 3.43936 2.17518 3.18753 2.48584 3.18753H4.73591C4.78094 3.18753 4.79336 3.18748 4.80352 3.18723C5.18951 3.17744 5.53002 2.93202 5.66136 2.56893C5.66481 2.55938 5.66879 2.54761 5.68303 2.50488L5.76673 2.25372C5.81796 2.09973 5.86259 1.96555 5.92503 1.84563C6.17174 1.37186 6.62819 1.04287 7.15566 0.958642C7.28918 0.937319 7.43057 0.937409 7.59285 0.937514ZM6.61695 3.18753C6.65558 3.11176 6.68982 3.03303 6.71927 2.95161C6.72821 2.92688 6.73699 2.90056 6.74825 2.86675L6.82311 2.64219C6.89149 2.43706 6.90723 2.39522 6.92285 2.36523C7.00508 2.2073 7.15724 2.09764 7.33306 2.06956C7.36646 2.06423 7.41111 2.06253 7.62735 2.06253H10.0945C10.3107 2.06253 10.3553 2.06423 10.3888 2.06956C10.5646 2.09764 10.7168 2.2073 10.799 2.36523C10.8146 2.39522 10.8303 2.43705 10.8987 2.64219L10.9735 2.86662L11.0026 2.95162C11.032 3.03304 11.0663 3.11176 11.1049 3.18753H6.61695Z" fill="currentColor"></path>
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M3.83761 5.81377C4.14757 5.7931 4.41561 6.02763 4.43628 6.3376L4.78123 11.5119C4.84862 12.5228 4.89664 13.2262 5.00207 13.7554C5.10433 14.2688 5.24708 14.5405 5.45215 14.7323C5.6572 14.9241 5.93782 15.0485 6.45682 15.1164C6.99187 15.1864 7.6969 15.1875 8.71 15.1875H9.29004C10.3031 15.1875 11.0081 15.1864 11.5432 15.1164C12.0622 15.0485 12.3428 14.9241 12.5479 14.7323C12.7529 14.5405 12.8957 14.2688 12.998 13.7554C13.1034 13.2262 13.1514 12.5228 13.2188 11.5119L13.5638 6.3376C13.5844 6.02763 13.8524 5.7931 14.1624 5.81377C14.4724 5.83443 14.7069 6.10246 14.6863 6.41244L14.3387 11.6262C14.2745 12.5883 14.2228 13.3654 14.1013 13.9752C13.975 14.6092 13.7602 15.1388 13.3165 15.5538C12.8728 15.9689 12.3301 16.148 11.6891 16.2319C11.0726 16.3125 10.2938 16.3125 9.32957 16.3125H8.67047C7.70627 16.3125 6.92743 16.3125 6.3109 16.2319C5.66991 16.148 5.12725 15.9689 4.68356 15.5538C4.23986 15.1388 4.02505 14.6092 3.89875 13.9752C3.77727 13.3654 3.72547 12.5883 3.66136 11.6262L3.31377 6.41244C3.2931 6.10246 3.52763 5.83443 3.83761 5.81377Z" fill="currentColor"></path>
                        </svg>
                    </a>
                </div>
            </div>
        </div>
        <div class="inner-content">
            <?php $tagline = boxcar_listing_display_meta($post, 'tagline', '', false); ?>
            <?php the_title( sprintf( '<h2 class="listing-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
            <?php echo trim($tagline); ?>

            <?php
            $meta_obj = WP_CarDealer_Listing_Meta::get_instance($post->ID);
            $unit = wp_cardealer_get_option('search_distance_unit', 'miles');
            if ( $unit == 'miles' ) {
                $unit = esc_html__('Miles', 'boxcar');
            } elseif( $unit == 'km' ) {
                $unit = esc_html__('Km', 'boxcar');
            }
            $mileage = boxcar_listing_display_meta($post, 'mileage', 'flaticon-speedometer', false, $unit);
            $fuel_type = boxcar_listing_display_tax_without_url($post, 'fuel_type', 'flaticon-gasoline-pump', false, false );
            $transmission = boxcar_listing_display_tax_without_url($post, 'transmission', 'flaticon-gearbox', false, false );

            if ( $mileage || $transmission || $fuel_type ) {
            ?>
                <div class="listing-metas d-flex align-items-center flex-wrap justify-content-between">
                    <?php
                        echo trim($mileage);
                        echo trim($fuel_type);
                        echo trim($transmission);
                    ?>
                </div>
            <?php } ?>

            <div class="bottom-info d-flex align-items-end">
                <?php boxcar_listing_display_price($post); ?>
                <a href="<?php the_permalink(); ?>" class="btn-readmore text-theme ms-auto"><?php echo esc_html__( 'View Details', 'boxcar' )?><svg xmlns="http://www.w3.org/2000/svg" class="next" width="14" height="14" viewBox="0 0 14 14" fill="none">
                    <path d="M13.6109 0H5.05533C4.84037 0 4.66643 0.173943 4.66643 0.388901C4.66643 0.603859 4.84037 0.777802 5.05533 0.777802H12.6721L0.113697 13.3362C-0.0382246 13.4881 -0.0382246 13.7342 0.113697 13.8861C0.18964 13.962 0.289171 14 0.388666 14C0.488161 14 0.587656 13.962 0.663635 13.8861L13.222 1.3277V8.94447C13.222 9.15943 13.3959 9.33337 13.6109 9.33337C13.8259 9.33337 13.9998 9.15943 13.9998 8.94447V0.388901C13.9998 0.173943 13.8258 0 13.6109 0Z" fill="currentColor"/>
                    </svg></a>
            </div>
        </div>
    </article><!-- #post-## -->
    <?php do_action( 'wp_cardealer_after_listing_content', $post->ID ); ?>
</div>