<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
global $post;

wp_enqueue_script( 'sticky-kit' );
?>

<?php do_action( 'wp_cardealer_before_listing_detail', $post->ID ); ?>

<article id="post-<?php the_ID(); ?>" <?php post_class('listing-single-layout listing-single-v1'); ?>>
	
	<div class="<?php echo apply_filters('boxcar_listing_content_class', 'container');?>">
		
		<?php boxcar_render_breadcrumbs_simple(); ?>

		<!-- Content header -->
		<?php echo WP_CarDealer_Template_Loader::get_template_part( 'single-listing/header' ); ?>

		<!-- Main content -->
		<div class="content-listing-detail">

			<div class="row listing-v-wrapper">
				<div class="col-xs-12 listing-detail-main col-md-<?php echo esc_attr( is_active_sidebar( 'listing-single-sidebar' ) ? 8 : 12); ?> col-lg-<?php echo esc_attr( is_active_sidebar( 'listing-single-sidebar' ) ? 8 : 12); ?>">

					<?php do_action( 'wp_cardealer_before_listing_content', $post->ID ); ?>

					<?php echo WP_CarDealer_Template_Loader::get_template_part( 'single-listing/gallery' ); ?>

					<?php
					if ( boxcar_get_config('show_listing_detail', true) ) {
						echo WP_CarDealer_Template_Loader::get_template_part( 'single-listing/detail' );
					}
					?>

					<?php
					if ( boxcar_get_config('show_listing_description', true) ) {
						echo WP_CarDealer_Template_Loader::get_template_part( 'single-listing/description' );
					}				
					?>

					<?php
					if ( boxcar_get_config('show_listing_attachments', true) ) {
						echo WP_CarDealer_Template_Loader::get_template_part( 'single-listing/attachments' );
					}
					?>

					<?php do_action( 'wp_cardealer_after_listing_content', $post->ID ); ?>
				</div>
				
				<?php if ( is_active_sidebar( 'listing-single-sidebar' ) ): ?>
					<div class="col-xs-12 col-md-4 col-lg-4 sidebar-listing sidebar-wrapper sticky-this">
				   		<div class="sidebar sidebar-right">
					   		<?php dynamic_sidebar( 'listing-single-sidebar' ); ?>
				   		</div>
				   	</div>
			   	<?php endif; ?>
			   	<div class="col-xs-12 listing-detail-main col-md-<?php echo esc_attr( is_active_sidebar( 'listing-single-sidebar' ) ? 8 : 12); ?> col-lg-<?php echo esc_attr( is_active_sidebar( 'listing-single-sidebar' ) ? 8 : 12); ?>">

			   		<?php
					if ( boxcar_get_config('show_listing_features', true) ) {
						echo WP_CarDealer_Template_Loader::get_template_part( 'single-listing/features' );
					}
					?>

			   		<?php
					if ( boxcar_get_config('show_listing_location', true) ) {
						echo WP_CarDealer_Template_Loader::get_template_part( 'single-listing/location' );
					}
					?>
					
					<?php if ( WP_CarDealer_Review::review_enable() ) { ?>
							<?php comments_template(); ?>
					<?php } ?>

			   	</div>
			</div>
		</div>
	</div>
	<?php
	if ( boxcar_get_config('show_listing_related', true) ) {
		echo WP_CarDealer_Template_Loader::get_template_part( 'single-listing/related' );
	}
	?>
</article><!-- #post-## -->

<?php do_action( 'wp_cardealer_after_listing_detail', $post->ID ); ?>