<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
global $wp_query;

if ( get_query_var( 'paged' ) ) {
    $paged = get_query_var( 'paged' );
} elseif ( get_query_var( 'page' ) ) {
    $paged = get_query_var( 'page' );
} else {
    $paged = 1;
}

$query_args = array(
	'post_type' => 'dealer',
    'post_status' => 'publish',
    'posts_per_page' => wp_cardealer_get_option('number_dealers_per_page', 10),
    'paged' => $paged,
);
$params = array();
$taxs = ['category', 'location'];
foreach ($taxs as $tax) {
	if ( is_tax('dealer_'.$tax) ) {
		$term = $wp_query->queried_object;
		if ( isset( $term->slug) ) {
			$params['filter-'.$tax] = $term->slug;
		}
	}
}

if ( WP_CarDealer_Abstract_Filter::has_filter() ) {
	$params = array_merge($params, $_GET);
}
$dealers = WP_CarDealer_Query::get_posts($query_args, $params);


if ( isset( $_REQUEST['load_type'] ) && WP_CarDealer_Mixes::is_ajax_request() ) {
	if ( 'items' !== $_REQUEST['load_type'] ) {
        echo WP_CarDealer_Template_Loader::get_template_part('archive-dealer-ajax-full', array('dealers' => $dealers));
	} else {
		echo WP_CarDealer_Template_Loader::get_template_part('archive-dealer-ajax-dealers', array('dealers' => $dealers));
	}

} else {
	get_header();
	
	$args = array(
		'dealers' => $dealers,
		'settings' => array(),
	);

		$sidebar_configs = boxcar_get_dealers_layout_configs();
	?>
		
		<section id="main-container" class="inner layout-type-default">
			
			<?php
				boxcar_render_breadcrumbs();
			?>

			<div class="main-content container inner">
				
				<?php boxcar_before_content( $sidebar_configs ); ?>
				
				<div class="row">
					<?php boxcar_display_sidebar_left( $sidebar_configs ); ?>

					<div id="main-content" class="col-sm-12 <?php echo esc_attr($sidebar_configs['main']['class']); ?>">
						<main id="main" class="site-main layout-type-default" role="main">

							<?php
								echo WP_CarDealer_Template_Loader::get_template_part('loop/dealer/archive-inner', $args);

								echo WP_CarDealer_Template_Loader::get_template_part('loop/dealer/pagination', $args);
							?>

						</main><!-- .site-main -->
					</div><!-- .content-area -->
					
					<?php boxcar_display_sidebar_right( $sidebar_configs ); ?>
				</div>

			</div>
		</section>
	<?php

	get_footer();
}