<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
global $wp_query, $boxcar_dealers;

if ( get_query_var( 'paged' ) ) {
    $paged = get_query_var( 'paged' );
} elseif ( get_query_var( 'page' ) ) {
    $paged = get_query_var( 'page' );
} else {
    $paged = 1;
}

$query_args = array(
	'post_type' => 'dealer',
    'post_status' => 'publish',
    'posts_per_page' => wp_cardealer_get_option('number_dealers_per_page', 10),
    'paged' => $paged,
);
$params = array();
$taxs = ['type', 'category', 'color', 'condition', 'cylinder', 'door', 'drive_type', 'feature', 'fuel_type', 'make', 'location', 'model', 'offer_type', 'transmission', 'label'];
foreach ($taxs as $tax) {
	if ( is_tax('dealer_'.$tax) ) {
		$term = $wp_query->queried_object;
		if ( isset( $term->slug) ) {
			$params['filter-'.$tax] = $term->slug;
		}
	}
}

if ( WP_CarDealer_Abstract_Filter::has_filter() ) {
	$params = array_merge($params, $_GET);
}
$boxcar_dealers = WP_CarDealer_Query::get_posts($query_args, $params);


if ( isset( $_REQUEST['load_type'] ) && WP_CarDealer_Mixes::is_ajax_request() ) {
	$args = array(
		'dealers' => $boxcar_dealers,
		'settings' => !empty( $_REQUEST['settings'] ) ? $_REQUEST['settings'] : array()
	);
	if ( 'items' !== $_REQUEST['load_type'] ) {
        echo WP_CarDealer_Template_Loader::get_template_part('archive-dealer-ajax-full', $args);
	} else {
		echo WP_CarDealer_Template_Loader::get_template_part('archive-dealer-ajax-dealers', $args);
	}

} else {
	get_header();

	?>
		<section id="main-container" class="inner ">
			<?php do_action('boxcar_dealer_archive_content'); ?>
		</section>
	<?php

	get_footer();
}