<?php
/**
 * The template for displaying pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that
 * other "pages" on your WordPress site will use a different template.
 *
 * @package WordPress
 * @subpackage Boxcar
 * @since Boxcar 1.0
 */
/*
*Template Name: Listings Template
*/

global $boxcar_listings;
if ( get_query_var( 'paged' ) ) {
    $paged = get_query_var( 'paged' );
} elseif ( get_query_var( 'page' ) ) {
    $paged = get_query_var( 'page' );
} else {
    $paged = 1;
}

$query_args = array(
	'post_type' => 'listing',
    'post_status' => 'publish',
    'posts_per_page' => wp_cardealer_get_option('number_listings_per_page', 10),
    'paged' => $paged,
);
$params = null;
if ( WP_CarDealer_Listing_Filter::has_filter() ) {
	$params = $_GET;
}

$boxcar_listings = WP_CarDealer_Query::get_posts($query_args, $params);

if ( isset( $_REQUEST['load_type'] ) && WP_CarDealer_Mixes::is_ajax_request() ) {
	
	$args = array(
		'listings' => $boxcar_listings,
		'settings' => !empty( $_REQUEST['settings'] ) ? $_REQUEST['settings'] : array(),
		'pagination_settings' => !empty( $_REQUEST['pagination_settings'] ) ? $_REQUEST['pagination_settings'] : array()
	);
	
	if ( 'items' !== $_REQUEST['load_type'] ) {
        echo WP_CarDealer_Template_Loader::get_template_part('archive-listing-ajax-full', $args);
	} else {
		echo WP_CarDealer_Template_Loader::get_template_part('archive-listing-ajax-listings', $args);
	}
} else {
	get_header();
	?>

		<section id="main-container" class="inner">
			
			<?php
			// Start the loop.
			while ( have_posts() ) : the_post();
				
				// Include the page content template.
				the_content();

			// End the loop.
			endwhile;
			?>

		</section>


	<?php

	get_footer();
}