jQuery(document).ready(function($){
	"use strict";
	var boxcar_upload;
	var boxcar_selector;

	function boxcar_add_file(event, selector) {

		var upload = $(".uploaded-file"), frame;
		var $el = $(this);
		boxcar_selector = selector;

		event.preventDefault();

		// If the media frame already exists, reopen it.
		if ( boxcar_upload ) {
			boxcar_upload.open();
			return;
		} else {
			// Create the media frame.
			boxcar_upload = wp.media.frames.boxcar_upload =  wp.media({
				// Set the title of the modal.
				title: "Select Image",

				// Customize the submit button.
				button: {
					// Set the text of the button.
					text: "Selected",
					// Tell the button not to close the modal, since we're
					// going to refresh the page when the image is selected.
					close: false
				}
			});

			// When an image is selected, run a callback.
			boxcar_upload.on( 'select', function() {
				// Grab the selected attachment.
				var attachment = boxcar_upload.state().get('selection').first();

				boxcar_upload.close();
				boxcar_selector.find('.upload_image').val(attachment.attributes.url).change();
				if ( attachment.attributes.type == 'image' ) {
					boxcar_selector.find('.boxcar_screenshot').empty().hide().prepend('<img src="' + attachment.attributes.url + '">').slideDown('fast');
				}
			});

		}
		// Finally, open the modal.
		boxcar_upload.open();
	}

	function boxcar_remove_file(selector) {
		selector.find('.boxcar_screenshot').slideUp('fast').next().val('').trigger('change');
	}
	
	$('body').on('click', '.boxcar_upload_image_action .remove-image', function(event) {
		boxcar_remove_file( $(this).parent().parent() );
	});

	$('body').on('click', '.boxcar_upload_image_action .add-image', function(event) {
		boxcar_add_file(event, $(this).parent().parent());
	});

});