<?php

remove_action( 'widgets_init', array( WP_Private_Message::getInstance(), 'register_widgets' ) );

add_action( 'wp-cardealer-single-listing-contact-form', 'boxcar_private_message_form', 10, 2 );
function boxcar_private_message_form($post, $user_id) {
	$userdata = get_userdata( $user_id );
	?>
	<div class="send-private-wrapper">
		<a href="#send-private-message-wrapper-<?php echo esc_attr($post->ID); ?>" class="btn-show-popup send-private-message-btn btn btn-theme w-100"><?php esc_html_e('Message Dealer', 'boxcar'); ?><svg xmlns="http://www.w3.org/2000/svg" class="next" width="14" height="14" viewBox="0 0 14 14" fill="none">
            <path d="M13.6109 0H5.05533C4.84037 0 4.66643 0.173943 4.66643 0.388901C4.66643 0.603859 4.84037 0.777802 5.05533 0.777802H12.6721L0.113697 13.3362C-0.0382246 13.4881 -0.0382246 13.7342 0.113697 13.8861C0.18964 13.962 0.289171 14 0.388666 14C0.488161 14 0.587656 13.962 0.663635 13.8861L13.222 1.3277V8.94447C13.222 9.15943 13.3959 9.33337 13.6109 9.33337C13.8259 9.33337 13.9998 9.15943 13.9998 8.94447V0.388901C13.9998 0.173943 13.8258 0 13.6109 0Z" fill="currentColor"/>
            </svg></a>
	</div>
	<div id="send-private-message-wrapper-<?php echo esc_attr($post->ID); ?>" class="popup-inner send-private-message-wrapper mfp-hide" data-effect="fadeIn">
		<div class="header-info d-flex align-items-center">
			<h3 class="title"><?php echo sprintf(esc_html__('Send message to "%s"', 'boxcar'), $userdata->display_name); ?></h3>
			<a href="javascript:void(0);" class="close-magnific-popup ms-auto"><i class="ti-close"></i></a>
		</div>
		<?php
		if ( is_user_logged_in() ) {
			?>
			<form id="send-message-form" class="send-message-form form-theme" action="?" method="post">
                <div class="form-group">
                	<label><?php echo esc_html__( 'Subject', 'boxcar' ); ?></label>
                    <input type="text" class="form-control" name="subject" placeholder="<?php esc_attr_e( 'enter subject...', 'boxcar' ); ?>" required="required">
                </div><!-- /.form-group -->
                <div class="form-group">
                	<label><?php echo esc_html__( 'Description', 'boxcar' ); ?></label>
                    <textarea class="form-control message" name="message" placeholder="<?php esc_attr_e( 'enter text here...', 'boxcar' ); ?>" required="required"></textarea>
                </div><!-- /.form-group -->

                <?php wp_nonce_field( 'wp-private-message-send-message', 'wp-private-message-send-message-nonce' ); ?>
              	<input type="hidden" name="recipient" value="<?php echo esc_attr($user_id); ?>">
              	<input type="hidden" name="action" value="wp_private_message_send_message">
                <button class="button btn btn-theme send-message-btn"><?php echo esc_html__( 'Send Message', 'boxcar' ); ?> <svg xmlns="http://www.w3.org/2000/svg" class="next" width="14" height="14" viewBox="0 0 14 14" fill="none">
            <path d="M13.6109 0H5.05533C4.84037 0 4.66643 0.173943 4.66643 0.388901C4.66643 0.603859 4.84037 0.777802 5.05533 0.777802H12.6721L0.113697 13.3362C-0.0382246 13.4881 -0.0382246 13.7342 0.113697 13.8861C0.18964 13.962 0.289171 14 0.388666 14C0.488161 14 0.587656 13.962 0.663635 13.8861L13.222 1.3277V8.94447C13.222 9.15943 13.3959 9.33337 13.6109 9.33337C13.8259 9.33337 13.9998 9.15943 13.9998 8.94447V0.388901C13.9998 0.173943 13.8258 0 13.6109 0Z" fill="currentColor"/>
            </svg></button>
        	</form>
			<?php
		} else {
			$login_url = '';
			if ( function_exists('wp_cardealer_get_option') ) {
				$login_register_page_id = wp_cardealer_get_option('login_register_page_id');
				$login_url = get_permalink( $login_register_page_id );
			}
			?>
			<a href="<?php echo esc_url($login_url); ?>" class="login"><?php esc_html_e('Please login to send a private message', 'boxcar'); ?></a>
			<?php
		}
		?>
	</div>
	<?php
}

function boxcar_private_message_user_avatar($user_id) {
	echo boxcar_get_avatar($user_id, 54);
}