<?php

function boxcar_listing_display_image($post, $size = 'thumbnail') {
	if ( has_post_thumbnail($post->ID) ) {
		?>
	    <div class="image-thumbnail">
	        <a class="listing-image" href="<?php echo esc_url( get_permalink($post) ); ?>">
	        	<?php
        		$post_thumbnail_id = get_post_thumbnail_id($post->ID);
        		echo boxcar_get_attachment_thumbnail( $post_thumbnail_id, $size );
	        	?>
	        </a>
	    </div>
	    <?php
	}
}

function boxcar_listing_display_tax($post, $taxonomy_key, $icon = '', $show_title = false, $echo = true) {
	$terms = get_the_terms( $post->ID, 'listing_'.$taxonomy_key );
	ob_start();
	$number = 1;
	if ( $terms && ! is_wp_error( $terms ) ) {
		?>
		<div class="listing-meta listing-tax <?php echo esc_attr($taxonomy_key); ?>">
			<div class="listing-tax-inner">
			<?php
				if ($icon) {
					?>
						<span class="icon"><i class="<?php echo esc_attr($icon); ?>"></i></span>
					<?php
				}
				if ( $show_title) {
					$meta_obj = WP_CarDealer_Listing_Meta::get_instance($post->ID);
					$title = $meta_obj->get_post_meta_title( $taxonomy_key );
					?>
						<span class="title"><?php echo esc_html($title); ?>:</span>
					<?php
				}
			
				foreach ($terms as $term) {
					$color = get_term_meta( $term->term_id, '_color', true );
					$style = '';
					if ( $color ) {
						$style = 'color: '.$color;
					}
					?>
		            	<a href="<?php echo esc_url(get_term_link($term)); ?>" style="<?php echo esc_attr($style); ?>"><?php echo esc_html($term->name); ?></a><?php if($number < count($terms)) echo trim(', ');?>
		        	<?php  $number++;
		    	}
	    	?>
	    	</div>
	    </div>
    	<?php
    }
    $output = ob_get_clean();
    if ( $echo ) {
    	echo trim($output);
    } else {
    	return $output;
    }
}

function boxcar_listing_display_tax_without_url($post, $taxonomy_key, $icon = '', $show_title = false, $echo = true) {
	$terms = get_the_terms( $post->ID, 'listing_'.$taxonomy_key );
	ob_start();
	$number = 1;
	if ( $terms && ! is_wp_error( $terms ) ) {
		?>
		<div class="listing-meta listing-tax <?php echo esc_attr($taxonomy_key); ?>">
				<?php
				if ($icon) {
					?>
						<i class="<?php echo esc_attr($icon); ?>"></i>
					<?php
				}
				if ( $show_title) {
					$meta_obj = WP_CarDealer_Listing_Meta::get_instance($post->ID);
					$title = $meta_obj->get_post_meta_title( $taxonomy_key );
					?>
						<span class="title-meta"><?php echo esc_html($title); ?> </span>
					<?php
				} ?>
				<span class="value-suffix">
					<?php foreach ($terms as $term) {
						?>
			            	<?php echo esc_html($term->name); ?><?php if($number < count($terms)) echo trim(', ');?>
			        	<?php  $number++;
			    		} 
		    		?>
	    		</span>
	    </div>
    	<?php
    }
    $output = ob_get_clean();
    if ( $echo ) {
    	echo trim($output);
    } else {
    	return $output;
    }
}

function boxcar_listing_display_tax_list($post, $taxonomy_key, $show_url = true) {
	$meta_obj = WP_CarDealer_Listing_Meta::get_instance($post->ID);
	$meta_obj->check_post_meta_exist($taxonomy_key);
	if ( !$meta_obj->check_post_meta_exist($taxonomy_key) ) {
		return;
	}
	$tax_values = get_the_terms( $post->ID, 'listing_'.$taxonomy_key );
	
	$number = 1;
	if ( $tax_values && ! is_wp_error( $tax_values ) ) {
		?>
		<li>
			<div class="text"><?php echo esc_html($meta_obj->get_post_meta_title( $taxonomy_key )); ?>:</div>
			<div class="value">
				<?php
				foreach ($tax_values as $term) {
					if ( $show_url ) {
					?>
		            	<a class="listing-tax" href="<?php echo esc_url(get_term_link($term)); ?>"><?php echo esc_html($term->name); ?></a><?php if($number < count($tax_values)) echo trim(', ');?>
		        	<?php
		        	} else {
		        		?>
		        		<span class="listing-tax"><?php echo esc_html($term->name); ?></span><?php if($number < count($tax_values)) echo trim(', ');?>
		        		<?php
		        	}
		        	$number++;
		    	} ?>
		    </div>
	    </li>
    	<?php
    }
}

function boxcar_listing_display_condition_label($post, $echo = true, $color = true) {
	$meta_obj = WP_CarDealer_Listing_Meta::get_instance($post->ID);
	$meta_obj->check_post_meta_exist('condition');
	if ( !$meta_obj->check_post_meta_exist('condition') ) {
		return;
	}

	$statuses = get_the_terms( $post->ID, 'listing_condition' );
	ob_start();
	if ( $statuses && ! is_wp_error( $statuses ) ) {
		foreach ($statuses as $term) {
			$text_color = get_term_meta( $term->term_id, 'text_color', true );
			$bg_color = get_term_meta( $term->term_id, 'bg_color', true );
			$style = '';
			if ( $color ) {
				if ( $bg_color ) {
					$style .= 'background: '.$bg_color.';';
				}
				if ( $text_color ) {
					$style .= 'color: '.$text_color.';';
				}
			}
			?>
            	<a class="status-property-label" href="<?php echo esc_url(get_term_link($term)); ?>" style="<?php echo esc_attr($style); ?>"><?php echo esc_html($term->name); ?></a>
        	<?php
    	}
    }
    $output = ob_get_clean();
    if ( $echo ) {
    	echo trim($output);
    } else {
    	return $output;
    }
}

function boxcar_listing_display_label_label($post, $echo = true, $color = true) {
	$meta_obj = WP_CarDealer_Listing_Meta::get_instance($post->ID);
	$meta_obj->check_post_meta_exist('label');
	if ( !$meta_obj->check_post_meta_exist('label') ) {
		return;
	}

	$statuses = get_the_terms( $post->ID, 'listing_label' );
	ob_start();
	if ( $statuses && ! is_wp_error( $statuses ) ) {
		foreach ($statuses as $term) {
			$text_color = get_term_meta( $term->term_id, 'text_color', true );
			$bg_color = get_term_meta( $term->term_id, 'bg_color', true );
			$style = '';
			if ( $color ) {
				if ( $bg_color ) {
					$style .= 'background: '.$bg_color.';';
				}
				if ( $text_color ) {
					$style .= 'color: '.$text_color.';';
				}
			}
			?>
            	<a class="status-property-label featured-listing" href="<?php echo esc_url(get_term_link($term)); ?>" style="<?php echo esc_attr($style); ?>"><?php echo esc_html($term->name); ?></a>
        	<?php
    	}
    }
    $output = ob_get_clean();
    if ( $echo ) {
    	echo trim($output);
    } else {
    	return $output;
    }
}

function boxcar_listing_display_full_location($post, $display_type = 'no-icon-title', $echo = true) {
	$meta_obj = WP_CarDealer_Listing_Meta::get_instance($post->ID);

	$location = $meta_obj->get_post_meta( 'address' );
	if ( empty($location) ) {
		$location = $meta_obj->get_post_meta( 'map_location_address' );
	}
	ob_start();
	if ( $location ) {
		if ( $display_type == 'icon' ) {
			?>
			<div class="listing-location with-icon"><i class="flaticon-map"></i> <a href="<?php echo esc_url( '//maps.google.com/maps?q=' . urlencode( strip_tags( $location ) ) . '&zoom=14&size=512x512&maptype=roadmap&sensor=false' ); ?>" target="_blank"><?php echo esc_html($location); ?></a></div>
			<?php
		} elseif ( $display_type == 'title' ) {
			?>
			<div class="listing-location with-title">
				<strong><?php esc_html_e('Location:', 'boxcar'); ?></strong> <a href="<?php echo esc_url( '//maps.google.com/maps?q=' . urlencode( strip_tags( $location ) ) . '&zoom=14&size=512x512&maptype=roadmap&sensor=false' ); ?>" target="_blank"><?php echo esc_html($location); ?></a>
			</div>
			<?php
		} else {
			?>
			<div class="listing-location"><a href="<?php echo esc_url( '//maps.google.com/maps?q=' . urlencode( strip_tags( $location ) ) . '&zoom=14&size=512x512&maptype=roadmap&sensor=false' ); ?>" target="_blank"><?php echo esc_html($location); ?></a></div>
			<?php
		}
    }
    $output = ob_get_clean();
    if ( $echo ) {
    	echo trim($output);
    } else {
    	return $output;
    }
}

function boxcar_listing_display_location_btn($post) {
	$meta_obj = WP_CarDealer_Listing_Meta::get_instance($post->ID);

	$location = $meta_obj->get_post_meta( 'map_location_address' );
	
	if ( empty($location) ) {
		$location = $meta_obj->get_post_meta( 'address' );
	}
	if ( $location ) {
		?>
		<a class="btn-direction text-theme" href="<?php echo esc_url( '//maps.google.com/maps?q=' . urlencode( strip_tags( $location ) ) . '&zoom=14&size=512x512&maptype=roadmap&sensor=false' ); ?>" target="_blank"><?php esc_html_e('Get Direction', 'boxcar'); ?><svg xmlns="http://www.w3.org/2000/svg" class="next" width="14" height="14" viewBox="0 0 14 14" fill="none">
            <path d="M13.6109 0H5.05533C4.84037 0 4.66643 0.173943 4.66643 0.388901C4.66643 0.603859 4.84037 0.777802 5.05533 0.777802H12.6721L0.113697 13.3362C-0.0382246 13.4881 -0.0382246 13.7342 0.113697 13.8861C0.18964 13.962 0.289171 14 0.388666 14C0.488161 14 0.587656 13.962 0.663635 13.8861L13.222 1.3277V8.94447C13.222 9.15943 13.3959 9.33337 13.6109 9.33337C13.8259 9.33337 13.9998 9.15943 13.9998 8.94447V0.388901C13.9998 0.173943 13.8258 0 13.6109 0Z" fill="currentColor"/>
            </svg></a>
		<?php
    }
}

function boxcar_listing_display_full_location_without_url($post_id, $display_type = 'no-icon-title', $echo = true) {
	if ( is_object($post_id) ) {
		$post_id = $post_id->ID;
	}
	$meta_obj = WP_CarDealer_Listing_Meta::get_instance($post_id);

	$location = $meta_obj->get_post_meta( 'address' );
	if ( empty($location) ) {
		$location = $meta_obj->get_post_meta( 'map_location_address' );
	}
	ob_start();
	if ( $location ) {
		if ( $display_type == 'icon' ) {
			?>
			<div class="listing-location with-icon"><i class="flaticon-map"></i> <?php echo esc_html($location); ?></div>
			<?php
		} elseif ( $display_type == 'title' ) {
			?>
			<div class="listing-location with-title">
				<strong><?php esc_html_e('Location:', 'boxcar'); ?></strong> <?php echo esc_html($location); ?>
			</div>
			<?php
		} else {
			?>
			<div class="listing-location"><?php echo esc_html($location); ?></div>
			<?php
		}
    }
    $output = ob_get_clean();
    if ( $echo ) {
    	echo trim($output);
    } else {
    	return $output;
    }
}

function boxcar_listing_display_price($post_id, $display_type = 'no-icon-title', $echo = true) {
	if ( is_object($post_id) ) {
		$post_id = $post_id->ID;
	}
	$meta_obj = WP_CarDealer_Listing_Meta::get_instance($post_id);
	$price = boxcar_get_price_html($meta_obj, $post_id);
	ob_start();
	if ( $price ) {
		if ( $display_type == 'icon' ) {
			?>
			<div class="listing-price d-flex align-items-baseline with-icon"><i class="ti-credit-card"></i> <?php echo trim($price); ?></div>
			<?php
		} elseif ( $display_type == 'title' ) {
			$title = $meta_obj->get_post_meta_title( 'price' );
			?>
			<div class="listing-price d-flex align-items-baseline with-title">
				<strong><?php echo esc_html($title); ?>:</strong> <span><?php echo trim($price); ?></span>
			</div>
			<?php
		} else {
			?>
			<div class="listing-price d-flex align-items-baseline"><?php echo trim($price); ?></div>
			<?php
		}
    }
    $output = ob_get_clean();
    if ( $echo ) {
    	echo trim($output);
    } else {
    	return $output;
    }
}

function boxcar_get_price_html($meta_obj, $post_id) {
	$price_custom = $meta_obj->get_post_meta( 'price_custom' );
	if ( $price_custom ) {
		return apply_filters( 'wp-cardealer-get-price-html', $price_custom, $post_id, $meta_obj );
	}

	$old_price = $meta_obj->get_post_meta( 'old_price' );
	$price = $meta_obj->get_post_meta( 'price' );

	if ( empty( $price ) || ! is_numeric( $price ) ) {
		return false;
	}

	$price_html = '';
	if ( !empty( $old_price ) && is_numeric( $old_price ) ) {
		$old_price = WP_CarDealer_Price::format_price( $old_price );
		if ( $old_price ) {
			$price_html = '<div class="old-price">'.$old_price.'</div>';
		}
	}

	$price = WP_CarDealer_Price::format_price( $price );

	if ( $price ) {
		$price_html .= '<div class="main-price">'.$price.'</div>';
	}
	if ( $price_html ) {
		$price_prefix = $meta_obj->get_post_meta( 'price_prefix' );
		$price_suffix = $meta_obj->get_post_meta( 'price_suffix' );
		if ( $price_prefix ) {
			$price_html = '<span class="prefix-text additional-text">'.$price_prefix .'</span>'. $price_html;
		}
		if ( $price_suffix ) {
			$price_html = $price_html .'<span class="suffix-text additional-text">'. $price_suffix.'</span>';
		}
	}
	return $price_html;
}


function boxcar_listing_display_postdate($post, $display_type = 'no-icon-title', $format = 'normal', $echo = true) {
	ob_start();
	if ( $format == 'ago' ) {
		$post_date = sprintf(esc_html__('%s ago', 'boxcar'), human_time_diff(get_the_time('U'), current_time('timestamp')) );
	} else {
		$post_date = get_the_time(get_option('date_format'));
	}
	if ( $display_type == 'icon' ) {
		?>
		<div class="listing-postdate with-icon"><i class="flaticon-clock-1"></i> <?php echo trim($post_date); ?></div>
		<?php
	} elseif ( $display_type == 'title' ) {
		?>
		<div class="listing-postdate with-title">
			<strong><?php esc_html_e('Date:', 'boxcar'); ?></strong> <?php echo trim($post_date); ?>
		</div>
		<?php
	} else {
		?>
		<div class="listing-postdate"><?php echo trim($post_date); ?></div>
		<?php
	}
	$output = ob_get_clean();
    if ( $echo ) {
    	echo trim($output);
    } else {
    	return $output;
    }
}

function boxcar_listing_display_views($post, $display_type = 'no-icon-title', $echo = true) {
	ob_start();
	
	$views = WP_CarDealer_Listing::get_post_meta($post->ID, 'views');

	if ( $display_type == 'icon' ) {
		?>
		<div class="listing-views with-icon"><i class="flaticon-eye"></i> <?php echo esc_html($views); ?></div>
		<?php
	} elseif ( $display_type == 'title' ) {
		?>
		<div class="listing-views with-title">
			<strong><?php esc_html_e('Views:', 'boxcar'); ?></strong> <?php echo esc_html($views); ?>
		</div>
		<?php
	} else {
		?>
		<div class="listing-views"><?php echo esc_html($views); ?></div>
		<?php
	}
	$output = ob_get_clean();
    if ( $echo ) {
    	echo trim($output);
    } else {
    	return $output;
    }
}

function boxcar_listing_gallery_icon($post, $display_type = 'icon', $echo = true) {
	
	$meta_obj = WP_CarDealer_Listing_Meta::get_instance($post->ID);

	$gallery = $meta_obj->get_post_meta( 'gallery' );
	$count = 0;
	if ( $gallery ) {
		$count = count($gallery);
	}
	if ( has_post_thumbnail($post) ) {
		$count++;
	}
	if ( $count == 0 ) {
		return '';
	}
	ob_start();
	if ( $display_type == 'icon' ) {
		?>
		<div class="listing-gallery-count with-icon"><i class="flaticon-photo-camera"></i> <?php echo esc_html($count); ?></div>
		<?php
	} else {
		?>
		<div class="listing-gallery-count"><?php echo esc_html($count); ?></div>
		<?php
	}
	$output = ob_get_clean();
    if ( $echo ) {
    	echo trim($output);
    } else {
    	return $output;
    }
}

function boxcar_listing_video_icon($post, $display_type = 'icon', $echo = true) {
	
	$meta_obj = WP_CarDealer_Listing_Meta::get_instance($post->ID);

	ob_start();
	if ( $meta_obj->check_post_meta_exist('video') && ($video = $meta_obj->get_post_meta('video')) ) {
		if ( $display_type == 'icon' ) {
			?>
			<div class="listing-gallery-count with-icon"><i class="flaticon-play-button"></i></div>
			<?php
		} else {
			?>
			<div class="listing-gallery-count"><?php echo esc_html($count); ?></div>
			<?php
		}
	}
	$output = ob_get_clean();
    if ( $echo ) {
    	echo trim($output);
    } else {
    	return $output;
    }
}

function boxcar_listing_video_btn($post, $display_type = 'icon', $echo = true) {
	
	$meta_obj = WP_CarDealer_Listing_Meta::get_instance($post->ID);

	$video = $meta_obj->get_post_meta('video');
	
	ob_start();
	if ( $meta_obj->check_post_meta_exist('video') && ($video = $meta_obj->get_post_meta('video')) ) {
	?>
		<div class="listing-video">
			<a href="<?php echo esc_url($video); ?>" class="popup-video video-detail-listing">
				<i class="flaticon-play-button"></i><?php esc_html_e('Video', 'boxcar'); ?>
			</a>
		</div>
	<?php
	}
	
	$output = ob_get_clean();
    if ( $echo ) {
    	echo trim($output);
    } else {
    	return $output;
    }
}

function boxcar_listing_display_featured_icon($post, $echo = true, $add_class = '') {
	$meta_obj = WP_CarDealer_Listing_Meta::get_instance($post->ID);

	$featured = $meta_obj->get_post_meta( 'featured' );
	ob_start();
	if ( $featured ) {
		?>
        <span class="featured-listing <?php echo esc_attr($add_class); ?>"><?php esc_html_e('Featured', 'boxcar'); ?></span>
	    <?php
	}

    $output = ob_get_clean();
    if ( $echo ) {
    	echo trim($output);
    } else {
    	return $output;
    }
}

function boxcar_listing_item_map_meta($post) {
	$meta_obj = WP_CarDealer_Listing_Meta::get_instance($post->ID);

	$latitude = $meta_obj->get_post_meta( 'map_location_latitude' );
	$longitude = $meta_obj->get_post_meta( 'map_location_longitude' );

	$thumbnail_url = '';
	if ( has_post_thumbnail($post->ID) ) {
		$thumbnail_url = get_the_post_thumbnail_url( $post, 'boxcar-listing-grid' );
	}
	
	echo 'data-latitude="'.esc_attr($latitude).'" data-longitude="'.esc_attr($longitude).'" data-img="'.esc_url($thumbnail_url).'"';
}

function boxcar_listing_author_phone($post, $display_type = 'no-title', $echo = true, $always_show_phone = false) {
	
	$user_id = $post->post_author;

	$a_phone = get_user_meta($user_id, '_phone', true);
	$a_phone = boxcar_user_display_phone($a_phone, $display_type, false, $always_show_phone);
	
	if ( $echo ) {
		echo trim($a_phone);
	} else {
		return $a_phone;
	}
}

function boxcar_listing_display_gallery($post, $size = 'thumbnail') {
	if ( !boxcar_get_config('listing_archive_enable_gallery', true) ) {
		return;
	}
	$obj_property_meta = WP_CarDealer_Listing_Meta::get_instance($post->ID);

	$gallery = $obj_property_meta->get_post_meta( 'gallery' );
	if ( has_post_thumbnail() || $gallery ) {
		$images = [];
		if ( has_post_thumbnail() ) {
            $images[] = get_the_post_thumbnail_url($post, $size);
        }

        if ( empty($gallery) ) {
        	return;
        }
        foreach ( $gallery as $id => $src ) {
        	$img = wp_get_attachment_image_url($id, $size);
        	if ( $img ) {
        		$images[] = $img;
        	}
        }

        echo 'data-images="'.esc_attr(json_encode($images)).'"';
	}
}

function boxcar_listing_display_meta($post, $meta_key, $icon = '', $show_title = false, $suffix = '', $echo = false) {
	$meta_obj = WP_CarDealer_Listing_Meta::get_instance($post->ID);

	ob_start();
	if ( $meta_obj->check_post_meta_exist($meta_key) && ($value = $meta_obj->get_post_meta( $meta_key )) ) {
		?>
		<div class="listing-meta with-<?php echo esc_attr($show_title ? 'icon-title' : 'icon'); ?> <?php echo esc_attr($meta_key); ?>">

				
			<?php if ( !empty($icon) ) { ?>
				<i class="<?php echo esc_attr($icon); ?>"></i>
			<?php } ?>

			<?php if ( !empty($show_title) ) {
				$title = $meta_obj->get_post_meta_title( $meta_key );
			?>
				<span class="title-meta"><?php echo esc_html($title); ?> </span>
			<?php } ?>

			<span class="value-suffix">
				<?php echo esc_html($value); ?>
				<?php echo trim($suffix); ?>
			</span>

		</div>
		<?php
    }
    $output = ob_get_clean();
    if ( $echo ) {
    	echo trim($output);
    } else {
    	return $output;
    }
}

function boxcar_listing_display_custom_field_meta($post, $meta_key, $icon = '', $show_title = false, $suffix = '', $echo = false) {
	$meta_obj = WP_CarDealer_Listing_Meta::get_instance($post->ID);

	ob_start();
	if ( $meta_obj->check_custom_post_meta_exist($meta_key) && ($value = $meta_obj->get_custom_post_meta( $meta_key )) ) {
		?>
		<div class="listing-meta with-<?php echo esc_attr($show_title ? 'icon-title' : 'icon'); ?>">

			<?php if ( !empty($show_title) ) {
				$title = $meta_obj->get_custom_post_meta_title( $meta_key );
			?>
				<span class="title-meta">
					<?php echo esc_html($title); ?>
				</span>
			<?php } ?>

			<?php if ( !empty($icon) ) { ?>
				<i class="<?php echo esc_attr($icon); ?>"></i>
			<?php } ?>
			<span class="value-suffix">
				<?php echo esc_html($value); ?>
				<?php echo trim($suffix); ?>
			</span>

		</div>
		<?php
    }
    $output = ob_get_clean();
    if ( $echo ) {
    	echo trim($output);
    } else {
    	return $output;
    }
}

function boxcar_listing_compare_field_featured($value, $key, $post_id) {
	switch ($key) {
	 	case 'featured':
	 		$classes = 'no';
			if ( $value == 'on' ) {
				$classes = 'yes';
			}
			$value = '<span class="'.$classes.'"><i class="fas fa-star"></i><span>';
	 		break;
	}
	return $value;
}
add_filter('wp-cardealer-compare-field-value', 'boxcar_listing_compare_field_featured', 10, 3);

function boxcar_listing_display_rating($post) {
    if ( WP_CarDealer_Review::review_enable($post->ID) ) {
        $average_rating = get_post_meta( $post->ID, '_average_rating', true );
        $nb_reviews = get_post_meta( $post->ID, '_nb_reviews', true );
        if ( $average_rating > 0 && $nb_reviews ) { ?>
            <div class="star-rating">
                <?php WP_CarDealer_Review::print_review($average_rating, 'list', $nb_reviews); ?>
            </div>
        <?php }
    }
}

function boxcar_listing_print_btn($post, $show_title = false) {
	if ( boxcar_get_config('listing_enable_printer', true) ) {
        ?>
        <a href="javascript:void(0);" class="btn-print-listing" data-listing_id="<?php echo esc_attr($post->ID); ?>" data-nonce="<?php echo esc_attr(wp_create_nonce( 'boxcar-printer-listing-nonce' )); ?>" data-toggle="tooltip" title="<?php esc_attr_e('Print', 'boxcar'); ?>"><i class=" flaticon-printer"></i>
        	<?php if ( $show_title ) { ?>
        		<span><?php esc_html_e('Print', 'boxcar'); ?></span>
        	<?php } ?>
        </a>
        <?php
    }
}
