<?php

function boxcar_get_dealers( $params = array() ) {
	$params = wp_parse_args( $params, array(
		'limit' => -1,
		'post_status' => 'publish',
		'get_dealers_by' => 'recent',
		'orderby' => '',
		'order' => '',
		'post__in' => array(),
		'fields' => null, // ids
		'author' => null,
		'type' => array(), 'category' => array(), 'condition' => array(), 'make' => array(), 'model' => array()
	));
	extract($params);

	$query_args = array(
		'post_type'         => 'dealer',
		'posts_per_page'    => $limit,
		'post_status'       => $post_status,
		'orderby'       => $orderby,
		'order'       => $order,
	);

	$meta_query = array();
	switch ($get_dealers_by) {
		case 'recent':
			$query_args['orderby'] = 'date';
			$query_args['order'] = 'DESC';
			break;
		case 'featured':
			$meta_query[] = array(
				'key' => WP_CARDEALER_DEALER_PREFIX.'featured',
	           	'value' => 'on',
	           	'compare' => '=',
			);
			break;
		case 'popular':
			$query_args['meta_key'] = WP_CARDEALER_DEALER_PREFIX.'views';
			$query_args['order'] = 'DESC';
			$query_args['orderby'] = 'meta_value_num';
			break;
	}

	if ( !empty($post__in) ) {
    	$query_args['post__in'] = $post__in;
    }

    if ( !empty($fields) ) {
    	$query_args['fields'] = $fields;
    }

    if ( !empty($author) ) {
    	$query_args['author'] = $author;
    }

    $tax_query = array();

    $tax_keys = apply_filters('boxcar-dealer-get-tax-keys', array('type', 'category', 'condition', 'make', 'model'));
    foreach ($tax_keys as $tax_key) {
    	if ( !empty($params[$tax_key]) ) {
    		$tax_query[] = array(
	            'taxonomy'      => 'dealer_'.$tax_key,
	            'field'         => 'slug',
	            'terms'         => $params[$tax_key],
	            'operator'      => 'IN'
	        );
    	}
    }
    
    if ( !empty($tax_query) ) {
    	$query_args['tax_query'] = $tax_query;
    }
    
    if ( !empty($meta_query) ) {
    	$query_args['meta_query'] = $meta_query;
    }
    
	return new WP_Query( $query_args );
}


function boxcar_get_dealer_layout_type() {
	global $post;
	
	$layout_type = get_post_meta($post->ID, WP_CARDEALER_DEALER_PREFIX.'layout_type', true);
	
	if ( empty($layout_type) ) {
		$layout_type = boxcar_get_config( 'dealer_elementor_template' );
	}
	return apply_filters( 'boxcar_get_dealer_layout_type', $layout_type );
}

function boxcar_is_dealers_page() {
	if( is_post_type_archive('dealer') || is_tax('dealer_category') || is_tax('dealer_location') ) {
		return true;
	}
	return false;
}

function boxcar_is_dealer_single_page() {
	if ( is_singular('dealer') || apply_filters('boxcar_is_dealers_page', false) ) {
		return true;
	}
	return false;
}




add_filter( 'template_include', 'boxcar_dealer_set_template', 100 );
function boxcar_dealer_set_template($template) {
    if ( is_embed() ) {
        return $template;
    }
    if ( is_singular( 'dealer' ) ) {
    	$template_id = boxcar_get_dealer_layout_type();
        if ( $template_id ) {
            $template = WP_CarDealer_Template_Loader::locate('template-listings/single-dealer-elementor');
        }
    } elseif ( boxcar_is_dealers_page() ) {
        if ( boxcar_get_config( 'dealer_archive_elementor_template' ) ) {
            $template = WP_CarDealer_Template_Loader::locate('template-listings/archive-dealer-elementor');
        }
    }
    return $template;
}

add_action( 'boxcar_dealer_detail_content', 'boxcar_dealer_detail_builder_content', 5 );
function boxcar_dealer_detail_builder_content() {
    $template_id = boxcar_get_dealer_layout_type();
    if ( $template_id ) {
        $post = get_post($template_id);
        echo apply_filters( 'boxcar_generate_post_builder', '', $post, $template_id);
    }
}

add_action( 'boxcar_dealer_archive_content', 'boxcar_dealer_archive_builder_content', 5 );
function boxcar_dealer_archive_builder_content() {
    $template_id = boxcar_get_config('dealer_archive_elementor_template');
    if ( $template_id ) {
        $post = get_post($template_id);
        echo apply_filters( 'boxcar_generate_post_builder', '', $post, $template_id);
    }
}

add_action( 'boxcar_dealer_author_content', 'boxcar_dealer_author_builder_content', 5 );
function boxcar_dealer_author_builder_content() {
    $template_id = boxcar_get_config('user_profile_elementor_template');
    if ( $template_id ) {
        $post = get_post($template_id);
        echo apply_filters( 'boxcar_generate_post_builder', '', $post, $template_id);
    }
}

