<?php

function boxcar_dealer_display_image($post, $size = 'thumbnail') {
	if ( has_post_thumbnail($post->ID) ) {
		?>
        <a class="dealer-image" href="<?php echo esc_url( get_permalink($post) ); ?>">
        	<?php
    		$post_thumbnail_id = get_post_thumbnail_id($post->ID);
    		echo boxcar_get_attachment_thumbnail( $post_thumbnail_id, $size );
        	?>
        </a>
	    <?php
	}
}

function boxcar_dealer_display_tax($post, $taxonomy_key, $icon = '', $show_title = false, $echo = true) {
	$terms = get_the_terms( $post->ID, 'dealer_'.$taxonomy_key );
	ob_start();
	$number = 1;
	if ( $terms && ! is_wp_error( $terms ) ) {
		?>
		<div class="dealer-meta dealer-tax <?php echo esc_attr($taxonomy_key); ?>">
			<div class="dealer-tax-inner">
			<?php
				if ($icon) {
					?>
						<span class="icon"><i class="<?php echo esc_attr($icon); ?>"></i></span>
					<?php
				}
				if ( $show_title) {
					$meta_obj = WP_CarDealer_Dealer_Meta::get_instance($post->ID);
					$title = $meta_obj->get_post_meta_title( $taxonomy_key );
					?>
						<span class="title"><?php echo esc_html($title); ?>:</span>
					<?php
				}
			
				foreach ($terms as $term) {
					$color = get_term_meta( $term->term_id, '_color', true );
					$style = '';
					if ( $color ) {
						$style = 'color: '.$color;
					}
					?>
		            	<a href="<?php echo esc_url(get_term_link($term)); ?>" style="<?php echo esc_attr($style); ?>"><?php echo esc_html($term->name); ?></a><?php if($number < count($terms)) echo trim(', ');?>
		        	<?php  $number++;
		    	}
	    	?>
	    	</div>
	    </div>
    	<?php
    }
    $output = ob_get_clean();
    if ( $echo ) {
    	echo trim($output);
    } else {
    	return $output;
    }
}

function boxcar_dealer_display_tax_without_url($post, $taxonomy_key, $icon = '', $show_title = false, $echo = true) {
	$terms = get_the_terms( $post->ID, 'dealer_'.$taxonomy_key );
	ob_start();
	$number = 1;
	if ( $terms && ! is_wp_error( $terms ) ) {
		?>
		<div class="dealer-meta dealer-tax <?php echo esc_attr($taxonomy_key); ?>">
				<?php
				if ($icon) {
					?>
						<i class="<?php echo esc_attr($icon); ?>"></i>
					<?php
				}
				if ( $show_title) {
					$meta_obj = WP_CarDealer_Dealer_Meta::get_instance($post->ID);
					$title = $meta_obj->get_post_meta_title( $taxonomy_key );
					?>
						<span class="title-meta"><?php echo esc_html($title); ?> </span>
					<?php
				} ?>
				<span class="value-suffix">
					<?php foreach ($terms as $term) {
						?>
			            	<?php echo esc_html($term->name); ?><?php if($number < count($terms)) echo trim(', ');?>
			        	<?php  $number++;
			    		} 
		    		?>
	    		</span>
	    </div>
    	<?php
    }
    $output = ob_get_clean();
    if ( $echo ) {
    	echo trim($output);
    } else {
    	return $output;
    }
}

function boxcar_dealer_display_tax_list($post, $taxonomy_key, $show_url = true) {
	$meta_obj = WP_CarDealer_Dealer_Meta::get_instance($post->ID);
	$meta_obj->check_post_meta_exist($taxonomy_key);
	if ( !$meta_obj->check_post_meta_exist($taxonomy_key) ) {
		return;
	}
	$tax_values = get_the_terms( $post->ID, 'dealer_'.$taxonomy_key );
	
	$number = 1;
	if ( $tax_values && ! is_wp_error( $tax_values ) ) {
		?>
		<li>
			<div class="text"><?php echo esc_html($meta_obj->get_post_meta_title( $taxonomy_key )); ?>:</div>
			<div class="value">
				<?php
				foreach ($tax_values as $term) {
					if ( $show_url ) {
					?>
		            	<a class="dealer-tax" href="<?php echo esc_url(get_term_link($term)); ?>"><?php echo esc_html($term->name); ?></a><?php if($number < count($tax_values)) echo trim(', ');?>
		        	<?php
		        	} else {
		        		?>
		        		<span class="dealer-tax"><?php echo esc_html($term->name); ?></span><?php if($number < count($tax_values)) echo trim(', ');?>
		        		<?php
		        	}
		        	$number++;
		    	} ?>
		    </div>
	    </li>
    	<?php
    }
}

function boxcar_dealer_display_full_location($post, $display_type = 'no-icon-title', $echo = true) {
	$meta_obj = WP_CarDealer_Dealer_Meta::get_instance($post->ID);

	$location = $meta_obj->get_post_meta( 'address' );
	if ( empty($location) ) {
		$location = $meta_obj->get_post_meta( 'map_location_address' );
	}
	ob_start();
	if ( $location ) {
		if ( $display_type == 'icon' ) {
			?>
			<div class="dealer-location with-icon"><i class="flaticon-map"></i> <a href="<?php echo esc_url( '//maps.google.com/maps?q=' . urlencode( strip_tags( $location ) ) . '&zoom=14&size=512x512&maptype=roadmap&sensor=false' ); ?>" target="_blank"><?php echo esc_html($location); ?></a></div>
			<?php
		} elseif ( $display_type == 'title' ) {
			?>
			<div class="dealer-location with-title">
				<strong><?php esc_html_e('Location:', 'boxcar'); ?></strong> <a href="<?php echo esc_url( '//maps.google.com/maps?q=' . urlencode( strip_tags( $location ) ) . '&zoom=14&size=512x512&maptype=roadmap&sensor=false' ); ?>" target="_blank"><?php echo esc_html($location); ?></a>
			</div>
			<?php
		} else {
			?>
			<div class="dealer-location"><a href="<?php echo esc_url( '//maps.google.com/maps?q=' . urlencode( strip_tags( $location ) ) . '&zoom=14&size=512x512&maptype=roadmap&sensor=false' ); ?>" target="_blank"><?php echo esc_html($location); ?></a></div>
			<?php
		}
    }
    $output = ob_get_clean();
    if ( $echo ) {
    	echo trim($output);
    } else {
    	return $output;
    }
}

function boxcar_dealer_display_location_btn($post) {
	$meta_obj = WP_CarDealer_Dealer_Meta::get_instance($post->ID);

	$location = $meta_obj->get_post_meta( 'map_location_address' );
	
	if ( empty($location) ) {
		$location = $meta_obj->get_post_meta( 'address' );
	}
	if ( $location ) {
		?>
		<a class="btn-direction text-theme" href="<?php echo esc_url( '//maps.google.com/maps?q=' . urlencode( strip_tags( $location ) ) . '&zoom=14&size=512x512&maptype=roadmap&sensor=false' ); ?>" target="_blank"><?php esc_html_e('Get Direction', 'boxcar'); ?><svg xmlns="http://www.w3.org/2000/svg" class="next" width="14" height="14" viewBox="0 0 14 14" fill="none">
            <path d="M13.6109 0H5.05533C4.84037 0 4.66643 0.173943 4.66643 0.388901C4.66643 0.603859 4.84037 0.777802 5.05533 0.777802H12.6721L0.113697 13.3362C-0.0382246 13.4881 -0.0382246 13.7342 0.113697 13.8861C0.18964 13.962 0.289171 14 0.388666 14C0.488161 14 0.587656 13.962 0.663635 13.8861L13.222 1.3277V8.94447C13.222 9.15943 13.3959 9.33337 13.6109 9.33337C13.8259 9.33337 13.9998 9.15943 13.9998 8.94447V0.388901C13.9998 0.173943 13.8258 0 13.6109 0Z" fill="currentColor"/>
            </svg></a>
		<?php
    }
}

function boxcar_dealer_display_full_location_without_url($post_id, $display_type = 'no-icon-title', $echo = true) {
	if ( is_object($post_id) ) {
		$post_id = $post_id->ID;
	}
	$meta_obj = WP_CarDealer_Dealer_Meta::get_instance($post_id);

	$location = $meta_obj->get_post_meta( 'address' );
	if ( empty($location) ) {
		$location = $meta_obj->get_post_meta( 'map_location_address' );
	}
	ob_start();
	if ( $location ) {
		if ( $display_type == 'icon' ) {
			?>
			<div class="dealer-location with-icon"><i class="flaticon-map"></i> <?php echo esc_html($location); ?></div>
			<?php
		} elseif ( $display_type == 'title' ) {
			?>
			<div class="dealer-location with-title">
				<strong><?php esc_html_e('Location:', 'boxcar'); ?></strong> <?php echo esc_html($location); ?>
			</div>
			<?php
		} else {
			?>
			<div class="dealer-location"><?php echo esc_html($location); ?></div>
			<?php
		}
    }
    $output = ob_get_clean();
    if ( $echo ) {
    	echo trim($output);
    } else {
    	return $output;
    }
}


function boxcar_dealer_display_featured_icon($post, $echo = true, $add_class = '') {
	$meta_obj = WP_CarDealer_Dealer_Meta::get_instance($post->ID);

	$featured = $meta_obj->get_post_meta( 'featured' );
	ob_start();
	if ( $featured ) {
		?>
        <span class="featured-dealer <?php echo esc_attr($add_class); ?>"><?php esc_html_e('Featured', 'boxcar'); ?></span>
	    <?php
	}

    $output = ob_get_clean();
    if ( $echo ) {
    	echo trim($output);
    } else {
    	return $output;
    }
}

function boxcar_dealer_item_map_meta($post) {
	$meta_obj = WP_CarDealer_Dealer_Meta::get_instance($post->ID);

	$latitude = $meta_obj->get_post_meta( 'map_location_latitude' );
	$longitude = $meta_obj->get_post_meta( 'map_location_longitude' );

	$thumbnail_url = '';
	if ( has_post_thumbnail($post->ID) ) {
		$thumbnail_url = get_the_post_thumbnail_url( $post, 'boxcar-dealer-grid' );
	}
	
	echo 'data-latitude="'.esc_attr($latitude).'" data-longitude="'.esc_attr($longitude).'" data-img="'.esc_url($thumbnail_url).'"';
}

function boxcar_dealer_author_phone($post, $display_type = 'no-title', $echo = true, $always_show_phone = false) {
	
	$meta_obj = WP_CarDealer_Dealer_Meta::get_instance($post->ID);
	$a_phone = '';
	if ( $meta_obj->check_post_meta_exist('phone')  ) {
		$phone = $meta_obj->get_post_meta( 'phone' );
		$a_phone = boxcar_user_display_phone($phone, $display_type, false, $always_show_phone);
	}

	if ( $echo ) {
		echo trim($a_phone);
	} else {
		return $a_phone;
	}
}

function boxcar_dealer_display_time_status($post) {
	$meta_obj = WP_CarDealer_Dealer_Meta::get_instance($post->ID);
	$hours = $meta_obj->get_post_meta( 'hours' );
	$status = boxcar_get_current_time_status( $hours );
	
	if ( $status ) { ?>
		<div class="listing-time opening">
			<?php esc_html_e( 'Open', 'boxcar' ); ?>
		</div>
	<?php } else { ?>
		<div class="listing-time closed">
			<?php esc_html_e( 'Closed', 'boxcar' ); ?>
		</div>
	<?php }
}

function boxcar_dealer_display_meta($post, $meta_key, $icon = '', $show_title = false, $suffix = '', $echo = false) {
	$meta_obj = WP_CarDealer_Dealer_Meta::get_instance($post->ID);

	ob_start();
	if ( $meta_obj->check_post_meta_exist($meta_key) && ($value = $meta_obj->get_post_meta( $meta_key )) ) {
		?>
		<div class="dealer-meta with-<?php echo esc_attr($show_title ? 'icon-title' : 'icon'); ?> <?php echo esc_attr($meta_key); ?>">

				
			<?php if ( !empty($icon) ) { ?>
				<i class="<?php echo esc_attr($icon); ?>"></i>
			<?php } ?>

			<?php if ( !empty($show_title) ) {
				$title = $meta_obj->get_post_meta_title( $meta_key );
			?>
				<span class="title-meta"><?php echo esc_html($title); ?> </span>
			<?php } ?>

			<span class="value-suffix">
				<?php echo esc_html($value); ?>
				<?php echo trim($suffix); ?>
			</span>

		</div>
		<?php
    }
    $output = ob_get_clean();
    if ( $echo ) {
    	echo trim($output);
    } else {
    	return $output;
    }
}

function boxcar_dealer_display_custom_field_meta($post, $meta_key, $icon = '', $show_title = false, $suffix = '', $echo = false) {
	$meta_obj = WP_CarDealer_Dealer_Meta::get_instance($post->ID);

	ob_start();
	if ( $meta_obj->check_custom_post_meta_exist($meta_key) && ($value = $meta_obj->get_custom_post_meta( $meta_key )) ) {
		?>
		<div class="dealer-meta with-<?php echo esc_attr($show_title ? 'icon-title' : 'icon'); ?>">

			<?php if ( !empty($show_title) ) {
				$title = $meta_obj->get_custom_post_meta_title( $meta_key );
			?>
				<span class="title-meta">
					<?php echo esc_html($title); ?>
				</span>
			<?php } ?>

			<?php if ( !empty($icon) ) { ?>
				<i class="<?php echo esc_attr($icon); ?>"></i>
			<?php } ?>
			<span class="value-suffix">
				<?php echo esc_html($value); ?>
				<?php echo trim($suffix); ?>
			</span>

		</div>
		<?php
    }
    $output = ob_get_clean();
    if ( $echo ) {
    	echo trim($output);
    } else {
    	return $output;
    }
}

