<?php

function boxcar_wp_cardealer_customize_register( $wp_customize ) {

    $elementor_options = ['' => esc_html__('Choose a elementor template', 'boxcar')];
    if ( did_action( 'elementor/loaded' ) ) {
        $ele_obj = \Elementor\Plugin::$instance;
        $templates = $ele_obj->templates_manager->get_source( 'local' )->get_items();
        
        if ( !empty( $templates ) ) {
            foreach ( $templates as $template ) {
                $elementor_options[ $template['template_id'] ] = $template['title'] . ' (' . $template['type'] . ')';
            }
        }
    }

    // Listings Panel
    $wp_customize->add_panel( 'boxcar_settings_listing', array(
        'title' => esc_html__( 'Listings Settings', 'boxcar' ),
        'priority' => 4,
    ) );

    // General Section
    $wp_customize->add_section('boxcar_settings_listing_general', array(
        'title'    => esc_html__('General', 'boxcar'),
        'priority' => 1,
        'panel' => 'boxcar_settings_listing',
    ));

    // Other Setting ?
    $wp_customize->add_setting('boxcar_theme_options[listing_other_setting]', array(
        'capability' => 'edit_theme_options',
        'type'       => 'option',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control( new Boxcar_WP_Customize_Heading_Control($wp_customize, 'listing_other_setting', array(
        'label'    => esc_html__('Other Settings', 'boxcar'),
        'section'  => 'boxcar_settings_listing_general',
        'settings' => 'boxcar_theme_options[listing_other_setting]',
    )));

    // Show Full Phone Number
    $wp_customize->add_setting('boxcar_theme_options[listing_show_full_phone]', array(
        'capability' => 'edit_theme_options',
        'type'       => 'option',
        'default'    => '',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control('boxcar_theme_options_listing_show_full_phone', array(
        'settings' => 'boxcar_theme_options[listing_show_full_phone]',
        'label'    => esc_html__('Show Full Phone Number', 'boxcar'),
        'section'  => 'boxcar_settings_listing_general',
        'type'     => 'checkbox',
    ));

    // Enable Favorite
    $wp_customize->add_setting('boxcar_theme_options[listing_enable_favorite]', array(
        'capability' => 'edit_theme_options',
        'type'       => 'option',
        'default'    => '1',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control('boxcar_theme_options_listing_enable_favorite', array(
        'settings' => 'boxcar_theme_options[listing_enable_favorite]',
        'label'    => esc_html__('Enable Favorite', 'boxcar'),
        'section'  => 'boxcar_settings_listing_general',
        'type'     => 'checkbox',
    ));

    // Enable Compare
    $wp_customize->add_setting('boxcar_theme_options[listing_enable_compare]', array(
        'capability' => 'edit_theme_options',
        'type'       => 'option',
        'default'    => '1',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control('boxcar_theme_options_listing_enable_compare', array(
        'settings' => 'boxcar_theme_options[listing_enable_compare]',
        'label'    => esc_html__('Enable Compare', 'boxcar'),
        'section'  => 'boxcar_settings_listing_general',
        'type'     => 'checkbox',
    ));



    // Listing Archives
    $wp_customize->add_section('boxcar_settings_listing_archive', array(
        'title'    => esc_html__('Listing Archives', 'boxcar'),
        'priority' => 2,
        'panel' => 'boxcar_settings_listing',
    ));

    // General Setting ?
    $wp_customize->add_setting('boxcar_theme_options[listings_general_setting]', array(
        'capability' => 'edit_theme_options',
        'type'       => 'option',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control( new Boxcar_WP_Customize_Heading_Control($wp_customize, 'listings_general_setting', array(
        'label'    => esc_html__('General Settings', 'boxcar'),
        'section'  => 'boxcar_settings_listing_archive',
        'settings' => 'boxcar_theme_options[listings_general_setting]',
    )));

    if ( did_action( 'elementor/loaded' ) ) {
        $wp_customize->add_setting( 'boxcar_theme_options[listing_archive_elementor_template]', array(
            'default'        => '',
            'type'           => 'option',
            'sanitize_callback' => 'sanitize_text_field',
        ) );
        $wp_customize->add_control( 'boxcar_settings_listing_single_listing_archive_elementor_template', array(
            'label'   => esc_html__('Listing Layout', 'boxcar'),
            'section' => 'boxcar_settings_listing_archive',
            'type'    => 'select',
            'choices' => $elementor_options,
            'settings' => 'boxcar_theme_options[listing_archive_elementor_template]',
        ) );
    }
    
    // Enable Gallery
    $wp_customize->add_setting('boxcar_theme_options[listing_archive_enable_gallery]', array(
        'capability' => 'edit_theme_options',
        'type'       => 'option',
        'default'    => '1',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control('boxcar_theme_options_listing_archive_enable_gallery', array(
        'settings' => 'boxcar_theme_options[listing_archive_enable_gallery]',
        'label'    => esc_html__('Enable Gallery', 'boxcar'),
        'section'  => 'boxcar_settings_listing_archive',
        'type'     => 'checkbox',
    ));

    // layout
    $wp_customize->add_setting( 'boxcar_theme_options[listings_layout_sidebar]', array(
        'default'        => 'left-main',
        'type'           => 'option',
        'sanitize_callback' => 'sanitize_text_field',
    ) );

    $wp_customize->add_control( new Boxcar_WP_Customize_Radio_Image_Control( 
        $wp_customize, 
        'apus_settings_listings_layout_sidebar', 
        array(
            'label'   => esc_html__('Layout Type', 'boxcar'),
            'section' => 'boxcar_settings_listing_archive',
            'type'    => 'select',
            'choices' => array(
                'main' => array(
                    'title' => esc_html__('Main Only', 'boxcar'),
                    'img' => get_template_directory_uri() . '/inc/assets/images/screen1.png'
                ),
                'left-main' => array(
                    'title' => esc_html__('Left - Main Sidebar', 'boxcar'),
                    'img' => get_template_directory_uri() . '/inc/assets/images/screen2.png'
                ),
                'main-right' => array(
                    'title' => esc_html__('Main - Right Sidebar', 'boxcar'),
                    'img' => get_template_directory_uri() . '/inc/assets/images/screen3.png'
                ),
            ),
            'settings' => 'boxcar_theme_options[listings_layout_sidebar]',
            'description' => wp_kses(__('Select a sidebar layout for layout type <strong>"Default", "Top Map"</strong>.', 'boxcar'), array('strong' => array())),
        ) 
    ));


    // Single Listing
    $wp_customize->add_section('boxcar_settings_listing_single', array(
        'title'    => esc_html__('Listing Single', 'boxcar'),
        'priority' => 3,
        'panel' => 'boxcar_settings_listing',
    ));

    // General Setting ?
    $wp_customize->add_setting('boxcar_theme_options[listing_single_general_setting]', array(
        'capability' => 'edit_theme_options',
        'type'       => 'option',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control( new Boxcar_WP_Customize_Heading_Control($wp_customize, 'listing_single_general_setting', array(
        'label'    => esc_html__('General Settings', 'boxcar'),
        'section'  => 'boxcar_settings_listing_single',
        'settings' => 'boxcar_theme_options[listing_single_general_setting]',
    )));

    // Listing Elementor
    if ( did_action( 'elementor/loaded' ) ) {
        
        $wp_customize->add_setting( 'boxcar_theme_options[listing_elementor_template]', array(
            'default'        => '',
            'type'           => 'option',
            'sanitize_callback' => 'sanitize_text_field',
        ) );
        $wp_customize->add_control( 'boxcar_settings_listing_single_listing_elementor_template', array(
            'label'   => esc_html__('Listing Layout', 'boxcar'),
            'section' => 'boxcar_settings_listing_single',
            'type'    => 'select',
            'choices' => $elementor_options,
            'settings' => 'boxcar_theme_options[listing_elementor_template]',
        ) );
    }


    // Print Listing
    $wp_customize->add_section('boxcar_settings_listing_print', array(
        'title'    => esc_html__('Listing Print', 'boxcar'),
        'priority' => 4,
        'panel' => 'boxcar_settings_listing',
    ));

    // Show Print Button
    $wp_customize->add_setting('boxcar_theme_options[listing_enable_printer]', array(
        'capability' => 'edit_theme_options',
        'type'       => 'option',
        'default'       => '1',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control('boxcar_theme_options_listing_enable_printer', array(
        'settings' => 'boxcar_theme_options[listing_enable_printer]',
        'label'    => esc_html__('Show Print Button', 'boxcar'),
        'section'  => 'boxcar_settings_listing_print',
        'type'     => 'checkbox',
    ));

    // Print Logo
    $wp_customize->add_setting('boxcar_theme_options[print-logo]', array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'type'           => 'option',
        'sanitize_callback' => 'sanitize_text_field',

    ));

    $wp_customize->add_control( new WP_Customize_Image_Control($wp_customize, 'print-logo', array(
        'label'    => esc_html__('Print Logo', 'boxcar'),
        'section'  => 'boxcar_settings_listing_print',
        'settings' => 'boxcar_theme_options[print-logo]',
    )));

    $contents = apply_filters('boxcar_listing_single_print_content', array(
        'header' => esc_html__('Print Header', 'boxcar'),
        'qrcode' => esc_html__('Qrcode', 'boxcar'),
        'author' => esc_html__('Author', 'boxcar'),
        'description' => esc_html__('Description', 'boxcar'),
        'detail' => esc_html__('Detail', 'boxcar'),
        'features' => esc_html__('Features', 'boxcar'),
        'gallery' => esc_html__('Gallery', 'boxcar'),
    ));

    foreach ($contents as $key => $value) {
        // Show Social Share
        $wp_customize->add_setting('boxcar_theme_options[show_print_'.$key.']', array(
            'capability' => 'edit_theme_options',
            'type'       => 'option',
            'default'       => '1',
            'sanitize_callback' => 'sanitize_text_field',
        ));

        $wp_customize->add_control('boxcar_theme_options_show_print_'.$key, array(
            'settings' => 'boxcar_theme_options[show_print_'.$key.']',
            'label'    => sprintf(esc_html__('Show %s', 'boxcar'), $value),
            'section'  => 'boxcar_settings_listing_print',
            'type'     => 'checkbox',
        ));
    }




    // User Profile Settings
    $wp_customize->add_section('boxcar_settings_listing_user_profile', array(
        'title'    => esc_html__('User Profile Settings', 'boxcar'),
        'priority' => 5,
        'panel' => 'boxcar_settings_listing',
    ));

    // layout
    $wp_customize->add_setting( 'boxcar_theme_options[user_single_layout]', array(
        'default'        => '',
        'type'           => 'option',
        'sanitize_callback' => 'sanitize_text_field',
    ) );

    $wp_customize->add_setting( 'boxcar_theme_options[user_profile_elementor_template]', array(
        'default'        => '',
        'type'           => 'option',
        'sanitize_callback' => 'sanitize_text_field',
    ) );
    $wp_customize->add_control( 'boxcar_settings_listing_single_user_profile_elementor_template', array(
        'label'   => esc_html__('Listing Layout', 'boxcar'),
        'section' => 'boxcar_settings_listing_user_profile',
        'type'    => 'select',
        'choices' => $elementor_options,
        'settings' => 'boxcar_theme_options[user_profile_elementor_template]',
    ) );
}
add_action( 'customize_register', 'boxcar_wp_cardealer_customize_register', 15 );