<?php

function boxcar_wp_cardealer_dealer_customize_register( $wp_customize ) {

    $elementor_options = ['' => esc_html__('Choose a elementor template', 'boxcar')];
    if ( did_action( 'elementor/loaded' ) ) {
        $ele_obj = \Elementor\Plugin::$instance;
        $templates = $ele_obj->templates_manager->get_source( 'local' )->get_items();
        
        if ( !empty( $templates ) ) {
            foreach ( $templates as $template ) {
                $elementor_options[ $template['template_id'] ] = $template['title'] . ' (' . $template['type'] . ')';
            }
        }
    }


    // Dealer Archives
    $wp_customize->add_section('boxcar_settings_dealer_settings', array(
        'title'    => esc_html__('Dealer Settings', 'boxcar'),
        'priority' => 4,
    ));

    if ( did_action( 'elementor/loaded' ) ) {
        // Dealer Archive Elementor
        $wp_customize->add_setting( 'boxcar_theme_options[dealer_archive_elementor_template]', array(
            'default'        => '',
            'type'           => 'option',
            'sanitize_callback' => 'sanitize_text_field',
        ) );
        $wp_customize->add_control( 'boxcar_settings_listing_single_dealer_archive_elementor_template', array(
            'label'   => esc_html__('Dealer Archives Layout', 'boxcar'),
            'section' => 'boxcar_settings_dealer_settings',
            'type'    => 'select',
            'choices' => $elementor_options,
            'settings' => 'boxcar_theme_options[dealer_archive_elementor_template]',
        ) );
    
        // Dealer Single Elementor
        
        $wp_customize->add_setting( 'boxcar_theme_options[dealer_elementor_template]', array(
            'default'        => '',
            'type'           => 'option',
            'sanitize_callback' => 'sanitize_text_field',
        ) );
        $wp_customize->add_control( 'boxcar_settings_listing_single_dealer_elementor_template', array(
            'label'   => esc_html__('Dealer Single Layout', 'boxcar'),
            'section' => 'boxcar_settings_dealer_settings',
            'type'    => 'select',
            'choices' => $elementor_options,
            'settings' => 'boxcar_theme_options[dealer_elementor_template]',
        ) );
    }

}
add_action( 'customize_register', 'boxcar_wp_cardealer_dealer_customize_register', 15 );