<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Boxcar_Elementor_Widget_Detail_User_View_Cars_Btn extends Elementor\Widget_Base {

	public function get_name() {
		return 'apus_element_detail_user_view_cars_btn';
	}

	public function get_title() {
		return esc_html__( 'User Details:: View Cars Button', 'boxcar' );
	}

	public function get_categories() {
		return [ 'boxcar-user-detail-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Settings', 'boxcar' ),
			]
		);

		$this->add_control(
            'btn_text',
            [
                'label'         => esc_html__( 'Button Text', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'default'   => 'View All Cars',
            ]
        );

		$this->add_control(
			'selected_icon',
			[
				'label' => esc_html__( 'Icon', 'boxcar' ),
				'type' => Elementor\Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'fa-solid',
				],
			]
		);

		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

		$this->end_controls_section();


		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__( 'Title', 'boxcar' ),
				'tab' => Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'btn_color',
			[
				'label' => esc_html__( 'Text Color', 'boxcar' ),
				'type' => Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => Elementor\Core\Schemes\Color::get_type(),
					'value' => Elementor\Core\Schemes\Color::COLOR_1,
				],
				'selectors' => [
					// Stronger selector to avoid section style from overwriting
					'{{WRAPPER}} .btn-filter-author' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'typography',
				'scheme' => Elementor\Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .btn-filter-author',
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings();

        extract( $settings );

		
		if ( Elementor\Plugin::$instance->editor->is_edit_mode() ) {
			$author_obj = wp_get_current_user();
		} else {
			global $author_obj;
		}

		if ( $author_obj ) {
			?>
			<div class="user-detail-view-cars-btn <?php echo esc_attr($el_class); ?>">
				<?php
				$filter_url = WP_CarDealer_Mixes::get_listings_page_url();
				$filter_url = add_query_arg( 'filter-author', $author_obj->ID, $filter_url );
				?>
				<a class="btn-filter-author" href="<?php echo esc_url($filter_url); ?>" target="_blank">
					<?php echo esc_html($btn_text); ?>

					<?php
					if ( empty( $settings['icon'] ) && ! Elementor\Icons_Manager::is_migration_allowed() ) {
						// add old default
						$settings['icon'] = 'fa fa-star';
					}

					if ( ! empty( $settings['icon'] ) ) {
						$this->add_render_attribute( 'icon', 'class', $settings['icon'] );
						$this->add_render_attribute( 'icon', 'aria-hidden', 'true' );
					}

					$migrated = isset( $settings['__fa4_migrated']['selected_icon'] );
					$is_new = empty( $settings['icon'] ) && Elementor\Icons_Manager::is_migration_allowed();
					if ( $is_new || $migrated ) {
						Elementor\Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] );
					} else { ?>
						<i <?php $this->print_render_attribute_string( 'icon' ); ?>></i>
					<?php } ?>
				</a>
				
			</div>
			<?php
		}
	}

}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_Widget_Detail_User_View_Cars_Btn );
