<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Boxcar_Elementor_Widget_Detail_User_Single_Field extends Elementor\Widget_Base {

	public function get_name() {
		return 'apus_element_detail_user_single_field';
	}

	public function get_title() {
		return esc_html__( 'User Details:: Single Field', 'boxcar' );
	}
	
	public function get_categories() {
		return [ 'boxcar-user-detail-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Settings', 'boxcar' ),
			]
		);

		
        $all_fields = array(
        	'' => esc_html__('Choose a field', 'boxcar'),
        	'_user_email' => 'Email',
        	'_user_phone' => 'Phone',
        	'_user_address' => 'Address',
        );
        

        $this->add_control(
            'show_field',
            [
                'label' => esc_html__( 'Show field', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => $all_fields
            ]
        );

        $this->add_control(
			'selected_icon',
			[
				'label' => esc_html__( 'Icon', 'boxcar' ),
				'type' => Elementor\Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'fa-solid',
				],
			]
		);

		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings();

        extract( $settings );

		
		if ( Elementor\Plugin::$instance->editor->is_edit_mode() ) {
			$author_obj = wp_get_current_user();
		} else {
			global $author_obj;
		}

		if ( $author_obj ) {
			?>
			<div class="user-detail-single-field <?php echo esc_attr($el_class); ?>">
				<?php
					$value_html = '';
					if ( $show_field == '_user_email' ){
						$value_html = !empty($author_obj->user_email) ? $author_obj->user_email : '';
					} else {
						$value_html = get_user_meta($author_obj->ID, $show_field, true);
					}
				?>
				<div class="user-meta-item">
					<?php
					if ( empty( $settings['icon'] ) && ! Elementor\Icons_Manager::is_migration_allowed() ) {
						// add old default
						$settings['icon'] = 'fa fa-star';
					}

					if ( ! empty( $settings['icon'] ) ) {
						$this->add_render_attribute( 'icon', 'class', $settings['icon'] );
						$this->add_render_attribute( 'icon', 'aria-hidden', 'true' );
					}

					$migrated = isset( $settings['__fa4_migrated']['selected_icon'] );
					$is_new = empty( $settings['icon'] ) && Elementor\Icons_Manager::is_migration_allowed();
					if ( $is_new || $migrated ) {
						Elementor\Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] );
					} else { ?>
						<i <?php $this->print_render_attribute_string( 'icon' ); ?>></i>
					<?php } ?>

					<span class="content-value">
						<?php echo is_array($value_html) ? implode(', ', $value_html) : trim($value_html); ?>
					</span>
				</div>
			</div>
			<?php
		}
	}

}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_Widget_Detail_User_Single_Field );
