<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Boxcar_Elementor_Widget_Detail_User_Message_Button extends Elementor\Widget_Base {

	public function get_name() {
		return 'apus_element_detail_user_message_button';
	}

	public function get_title() {
		return esc_html__( 'User Details:: Send Message Button', 'boxcar' );
	}

	public function get_categories() {
		return [ 'boxcar-user-detail-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Settings', 'boxcar' ),
			]
		);

		$this->add_control(
            'btn_text',
            [
                'label'         => esc_html__( 'Button Text', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'default'   => 'Send Message',
            ]
        );

		$this->add_control(
			'selected_icon',
			[
				'label' => esc_html__( 'Icon', 'boxcar' ),
				'type' => Elementor\Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'fa-solid',
				],
			]
		);

		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

		$this->end_controls_section();


	}

	protected function render() {
		$settings = $this->get_settings();

        extract( $settings );

		
		if ( Elementor\Plugin::$instance->editor->is_edit_mode() ) {
			$author_obj = wp_get_current_user();
		} else {
			global $author_obj;
		}

		if ( $author_obj ) {
			
			?>
			<div class="user-message-button <?php echo esc_attr($el_class); ?>">
				<div class="send-private-wrapper">
					<a href="#send-private-message-wrapper-<?php echo esc_attr($author_obj->ID); ?>" class="btn-show-popup send-private-message-btn btn btn-theme w-100">
						<?php echo esc_html($btn_text); ?>

						<?php
						if ( empty( $settings['icon'] ) && ! Elementor\Icons_Manager::is_migration_allowed() ) {
							// add old default
							$settings['icon'] = 'fa fa-star';
						}

						if ( ! empty( $settings['icon'] ) ) {
							$this->add_render_attribute( 'icon', 'class', $settings['icon'] );
							$this->add_render_attribute( 'icon', 'aria-hidden', 'true' );
						}

						$migrated = isset( $settings['__fa4_migrated']['selected_icon'] );
						$is_new = empty( $settings['icon'] ) && Elementor\Icons_Manager::is_migration_allowed();
						if ( $is_new || $migrated ) {
							Elementor\Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] );
						} else { ?>
							<i <?php $this->print_render_attribute_string( 'icon' ); ?>></i>
						<?php } ?>
							
					</a>
				</div>
				<div id="send-private-message-wrapper-<?php echo esc_attr($author_obj->ID); ?>" class="popup-inner send-private-message-wrapper mfp-hide" data-effect="fadeIn">
					<div class="header-info d-flex align-items-center">
						<h3 class="title"><?php echo sprintf(esc_html__('Send message to "%s"', 'boxcar'), $author_obj->display_name); ?></h3>
						<a href="javascript:void(0);" class="close-magnific-popup ms-auto"><i class="ti-close"></i></a>
					</div>
					<?php
					if ( is_user_logged_in() ) {
						?>
						<form id="send-message-form" class="send-message-form form-theme" action="?" method="post">
			                <div class="form-group">
			                	<label><?php echo esc_html__( 'Subject', 'boxcar' ); ?></label>
			                    <input type="text" class="form-control" name="subject" placeholder="<?php esc_attr_e( 'enter subject...', 'boxcar' ); ?>" required="required">
			                </div><!-- /.form-group -->
			                <div class="form-group">
			                	<label><?php echo esc_html__( 'Description', 'boxcar' ); ?></label>
			                    <textarea class="form-control message" name="message" placeholder="<?php esc_attr_e( 'enter text here...', 'boxcar' ); ?>" required="required"></textarea>
			                </div><!-- /.form-group -->

			                <?php wp_nonce_field( 'wp-private-message-send-message', 'wp-private-message-send-message-nonce' ); ?>
			              	<input type="hidden" name="recipient" value="<?php echo esc_attr($author_obj->ID); ?>">
			              	<input type="hidden" name="action" value="wp_private_message_send_message">
			                <button class="button btn btn-theme send-message-btn">
			                	<?php echo esc_html($btn_text); ?>

								<?php
								if ( empty( $settings['icon'] ) && ! Elementor\Icons_Manager::is_migration_allowed() ) {
									// add old default
									$settings['icon'] = 'fa fa-star';
								}

								if ( ! empty( $settings['icon'] ) ) {
									$this->add_render_attribute( 'icon', 'class', $settings['icon'] );
									$this->add_render_attribute( 'icon', 'aria-hidden', 'true' );
								}

								$migrated = isset( $settings['__fa4_migrated']['selected_icon'] );
								$is_new = empty( $settings['icon'] ) && Elementor\Icons_Manager::is_migration_allowed();
								if ( $is_new || $migrated ) {
									Elementor\Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] );
								} else { ?>
									<i <?php $this->print_render_attribute_string( 'icon' ); ?>></i>
								<?php } ?>
			                </button>
			        	</form>
						<?php
					} else {
						$login_url = '';
						if ( function_exists('wp_cardealer_get_option') ) {
							$login_register_page_id = wp_cardealer_get_option('login_register_page_id');
							$login_url = get_permalink( $login_register_page_id );
						}
						?>
						<a href="<?php echo esc_url($login_url); ?>" class="login"><?php esc_html_e('Please login to send a private message', 'boxcar'); ?></a>
						<?php
					}
					?>
				</div>
			</div>
			<?php
		}
	}

}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_Widget_Detail_User_Message_Button );
