<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Boxcar_Elementor_Widget_Detail_User_Maps extends Elementor\Widget_Base {

	public function get_name() {
		return 'apus_element_detail_user_maps';
	}

	public function get_title() {
		return esc_html__( 'User Details:: Maps Location', 'boxcar' );
	}

	public function get_categories() {
		return [ 'boxcar-user-detail-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Settings', 'boxcar' ),
			]
		);
		
		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

		$this->end_controls_section();


	}

	protected function render() {
		$settings = $this->get_settings();

        extract( $settings );

		
		if ( Elementor\Plugin::$instance->editor->is_edit_mode() ) {
			$author_obj = wp_get_current_user();
		} else {
			global $author_obj;
		}

		if ( $author_obj ) {
			$map_location = get_user_meta($author_obj->ID, '_user_map_location', true);
			$address = isset($map_location['address']) ? $map_location['address'] : '';
			$latitude = isset($map_location['latitude']) ? $map_location['latitude'] : '';
			$longitude = isset($map_location['longitude']) ? $map_location['longitude'] : '';
			?>
			<div class="user-detail-maps <?php echo esc_attr($el_class); ?>">
				<?php if ( $address ) { ?>
		            <div class="direction-wrapper">
		                <div class="listing-location"><a href="<?php echo esc_url( '//maps.google.com/maps?q=' . urlencode( strip_tags( $address ) ) . '&zoom=14&size=512x512&maptype=roadmap&sensor=false' ); ?>" target="_blank"><?php echo esc_html($address); ?></a></div>

		                <a class="btn-direction text-theme" href="<?php echo esc_url( '//maps.google.com/maps?q=' . urlencode( strip_tags( $address ) ) . '&zoom=14&size=512x512&maptype=roadmap&sensor=false' ); ?>" target="_blank"><?php esc_html_e('Get Direction', 'boxcar'); ?><svg xmlns="http://www.w3.org/2000/svg" class="next" width="14" height="14" viewBox="0 0 14 14" fill="none">
            <path d="M13.6109 0H5.05533C4.84037 0 4.66643 0.173943 4.66643 0.388901C4.66643 0.603859 4.84037 0.777802 5.05533 0.777802H12.6721L0.113697 13.3362C-0.0382246 13.4881 -0.0382246 13.7342 0.113697 13.8861C0.18964 13.962 0.289171 14 0.388666 14C0.488161 14 0.587656 13.962 0.663635 13.8861L13.222 1.3277V8.94447C13.222 9.15943 13.3959 9.33337 13.6109 9.33337C13.8259 9.33337 13.9998 9.15943 13.9998 8.94447V0.388901C13.9998 0.173943 13.8258 0 13.6109 0Z" fill="currentColor"></path>
            </svg></a>
		            </div>
		        <?php } ?>
				<div id="single-listing-google-maps" class="single-listing-map" data-latitude="<?php echo esc_attr($latitude); ?>" data-longitude="<?php echo esc_attr($longitude); ?>"></div>
			</div>
			<?php
		}
	}

}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_Widget_Detail_User_Maps );
