<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Boxcar_Elementor_Widget_Detail_User_Listings extends Elementor\Widget_Base {

	public function get_name() {
		return 'apus_element_detail_user_listings';
	}

	public function get_title() {
		return esc_html__( 'User Details:: Listings', 'boxcar' );
	}

	public function get_categories() {
		return [ 'boxcar-user-detail-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Settings', 'boxcar' ),
			]
		);

		$this->add_control(
            'limit',
            [
                'label' => esc_html__( 'Limit', 'boxcar' ),
                'type' => Elementor\Controls_Manager::NUMBER,
                'input_type' => 'number',
                'description' => esc_html__( 'Limit listings to display', 'boxcar' ),
                'default' => 4
            ]
        );

		$this->add_control(
            'listing_item_style',
            [
                'label' => esc_html__( 'Listing Item Style', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    'grid' => esc_html__('Grid Default', 'boxcar'),
                    'grid-v1' => esc_html__('Grid V1', 'boxcar'),
                    'list' => esc_html__('List Default', 'boxcar'),
                    'list-v1' => esc_html__('List V1', 'boxcar'),
                ),
                'default' => 'grid',
            ]
        );

		$this->add_control(
            'layout_type',
            [
                'label' => esc_html__( 'Layout', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    'grid' => esc_html__('Grid', 'boxcar'),
                    'carousel' => esc_html__('Carousel', 'boxcar'),
                ),
                'default' => 'grid'
            ]
        );

        $columns = range( 1, 12 );
        $columns = array_combine( $columns, $columns );

        $this->add_responsive_control(
            'columns',
            [
                'label' => esc_html__( 'Columns', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => $columns,
                'frontend_available' => true,
                'default' => 3,
            ]
        );

        $this->add_responsive_control(
            'slides_to_scroll',
            [
                'label' => esc_html__( 'Slides to Scroll', 'boxcar' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'description' => esc_html__( 'Set how many slides are scrolled per swipe.', 'boxcar' ),
                'options' => $columns,
                'condition' => [
                    'columns!' => '1',
                    'layout_type' => 'carousel',
                ],
                'frontend_available' => true,
                'default' => 1,
            ]
        );

        $this->add_control(
            'rows',
            [
                'label' => esc_html__( 'Rows', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'number',
                'placeholder' => esc_html__( 'Enter your rows number here', 'boxcar' ),
                'default' => 1,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_control(
            'show_nav',
            [
                'label'         => esc_html__( 'Show Navigation', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Show', 'boxcar' ),
                'label_off'     => esc_html__( 'Hide', 'boxcar' ),
                'return_value'  => true,
                'default'       => true,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label'         => esc_html__( 'Show Pagination', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Show', 'boxcar' ),
                'label_off'     => esc_html__( 'Hide', 'boxcar' ),
                'return_value'  => true,
                'default'       => true,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_control(
            'slider_autoplay',
            [
                'label'         => esc_html__( 'Autoplay', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'boxcar' ),
                'label_off'     => esc_html__( 'No', 'boxcar' ),
                'return_value'  => true,
                'default'       => true,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_control(
            'infinite_loop',
            [
                'label'         => esc_html__( 'Infinite Loop', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'boxcar' ),
                'label_off'     => esc_html__( 'No', 'boxcar' ),
                'return_value'  => true,
                'default'       => true,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings();

        extract( $settings );

		
		if ( Elementor\Plugin::$instance->editor->is_edit_mode() ) {
			$author_obj = wp_get_current_user();
		} else {
			global $author_obj;
		}

		if ( $author_obj ) {
			?>
			<div class="user-detail-listings <?php echo esc_attr($el_class); ?>">

				<?php
				$columns = !empty($columns) ? $columns : 3;
                $columns_tablet = !empty($columns_tablet) ? $columns_tablet : 2;
                $columns_mobile = !empty($columns_mobile) ? $columns_mobile : 1;
                
                $slides_to_scroll = !empty($slides_to_scroll) ? $slides_to_scroll : 1;
                $slides_to_scroll_tablet = !empty($slides_to_scroll_tablet) ? $slides_to_scroll_tablet : $columns_tablet;
                $slides_to_scroll_mobile = !empty($slides_to_scroll_mobile) ? $slides_to_scroll_mobile : $columns_mobile;

				$args = array(
				    'post_type' => 'listing',
				    'posts_per_page' => $limit,
				    'author' => $author_obj->ID
				);
				$listings = new WP_Query( $args );
				if ( $listings->have_posts() ):
				?>
				    <?php if ( $layout_type == 'carousel' ): ?>
	                    <div class="slick-carousel nav-bottom"
	                            data-items="<?php echo esc_attr($columns); ?>"
                                data-large="<?php echo esc_attr( $columns_tablet ); ?>"
                                data-medium="<?php echo esc_attr( $columns_tablet ); ?>"
                                data-small="<?php echo esc_attr($columns_mobile); ?>"
                                data-smallest="<?php echo esc_attr($columns_mobile); ?>"

                                data-slidestoscroll="<?php echo esc_attr($slides_to_scroll); ?>"
                                data-slidestoscroll_large="<?php echo esc_attr( $slides_to_scroll_tablet ); ?>"
                                data-slidestoscroll_medium="<?php echo esc_attr( $slides_to_scroll_tablet ); ?>"
                                data-slidestoscroll_small="<?php echo esc_attr($slides_to_scroll_mobile); ?>"
                                data-slidestoscroll_smallest="<?php echo esc_attr($slides_to_scroll_mobile); ?>"

	                            data-pagination="<?php echo esc_attr( $show_pagination ? 'true' : 'false' ); ?>" data-nav="<?php echo esc_attr( $show_nav ? 'true' : 'false' ); ?>" data-rows="<?php echo esc_attr( $rows ); ?>" data-infinite="<?php echo esc_attr( $infinite_loop ? 'true' : 'false' ); ?>" data-autoplay="<?php echo esc_attr( $slider_autoplay ? 'true' : 'false' ); ?>">
	                        <?php while ( $listings->have_posts() ) : $listings->the_post(); ?>
	                            <div class="item">
	                                <?php echo WP_CarDealer_Template_Loader::get_template_part( 'listings-styles/inner-'.$listing_item_style ); ?>
	                            </div>
	                        <?php endwhile; ?>
	                    </div>
                    <?php else: ?>
                		<?php
                            $mdcol = 12/$columns;
                            $smcol = 12/$columns_tablet;
                            $xscol = 12/$columns_mobile;
                        ?>
                        <div class="row">
                            <?php while ( $listings->have_posts() ) : $listings->the_post(); ?>
                                <div class="col-md-<?php echo esc_attr($mdcol); ?> col-sm-<?php echo esc_attr($smcol); ?> col-<?php echo esc_attr( $xscol ); ?>">
                                    <?php echo WP_CarDealer_Template_Loader::get_template_part( 'listings-styles/inner-'. $listing_item_style ); ?>
                                </div>
                            <?php endwhile; ?>
                        </div>
                    <?php endif; ?>
                    <?php wp_reset_postdata(); ?>

				<?php endif; ?>
			</div>
			<?php
		}
	}

}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_Widget_Detail_User_Listings );
