<?php

//namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Boxcar_Elementor_User_Info extends Elementor\Widget_Base {

    public function get_name() {
        return 'apus_element_user_info';
    }

    public function get_title() {
        return esc_html__( 'Apus Header User Info', 'boxcar' );
    }
    
    public function get_categories() {
        return [ 'boxcar-header-elements' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Content', 'boxcar' ),
                'tab' => Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'login_text',
            [
                'label' => esc_html__( 'Login Text', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'Enter text here', 'boxcar' ),
                'default' => 'Login'
            ]
        );

        $this->add_control(
            'register_text',
            [
                'label' => esc_html__( 'Register Text', 'boxcar' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'Enter text here', 'boxcar' ),
                'default' => 'Register'
            ]
        );

        $this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'boxcar' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'boxcar' ),
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => esc_html__( 'Alignment', 'boxcar' ),
                'type' => Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'boxcar' ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'boxcar' ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'boxcar' ),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}}' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_title_style',
            [
                'label' => esc_html__( 'Color', 'boxcar' ),
                'tab' => Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label' => esc_html__( 'Color Text', 'boxcar' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .name-acount' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .top-wrapper-menu >a' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .space' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .login-icon.st_full' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'text_hover_color',
            [
                'label' => esc_html__( 'Color Hover Link', 'boxcar' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .top-wrapper-menu >a:hover' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .top-wrapper-menu >a:focus' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings();

        extract( $settings );

        if ( is_user_logged_in() ) {
            $user_id = get_current_user_id();
            $userdata = get_userdata($user_id);
            $user_name = $userdata->display_name;
            
            $menu_nav = 'user-menu';
            
            ?>
            <div class="top-wrapper-menu author-verify <?php echo esc_attr($el_class); ?>">
                <a class="drop-dow" href="javascript:void(0);">
                    <div class="infor-account">
                        <div class="avatar-wrapper">
                            <?php echo boxcar_get_avatar($user_id, 50); ?>
                        </div>
                    </div>
                </a>
                <?php
                    if ( !empty($menu_nav) && has_nav_menu( $menu_nav ) ) {
                        $args = array(
                            'theme_location' => $menu_nav,
                            'container_class' => 'inner-top-menu',
                            'menu_class' => 'nav navbar-nav topmenu-menu',
                            'fallback_cb' => '',
                            'menu_id' => '',
                            'walker' => new Boxcar_Nav_Menu()
                        );
                        wp_nav_menu($args);
                    }
                ?>
            </div>
        <?php } else {
            $login_page_id = wp_cardealer_get_option('login_page_id');
            $login_page_id = WP_CarDealer_Mixes::get_lang_post_id($login_page_id);

            $register_page_id = wp_cardealer_get_option('register_page_id');
            $register_page_id = WP_CarDealer_Mixes::get_lang_post_id($register_page_id);
        ?>
            <div class="top-wrapper-menu <?php echo esc_attr($el_class); ?>">
                
                <a class="btn-login btn-action-account" href="<?php echo esc_url( get_permalink( $login_page_id ) ); ?>" title="<?php echo esc_attr($login_text); ?>">
                    <i class="flaticon-user pre"></i><?php echo esc_html($login_text); ?>
                </a>
                <?php if(!empty($register_text)) { ?>
                    <a class="btn-register btn-action-account" href="<?php echo esc_url( get_permalink( $register_page_id ) ); ?>" title="<?php echo esc_attr($register_text); ?>">
                        <i class="flaticon-user pre"></i><?php echo esc_html($register_text); ?>
                    </a>
                <?php } ?>
            </div>
        <?php }
    }
}

Elementor\Plugin::instance()->widgets_manager->register( new Boxcar_Elementor_User_Info );